% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{rws_query}
\alias{rws_query}
\alias{rws_query_sqlite}
\title{Query SQLite Database}
\usage{
rws_query(query, meta = TRUE, conn)
}
\arguments{
\item{query}{A string of a SQLite query.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{conn}{A \code{\linkS4class{SQLiteConnection}} to a database.}
}
\value{
A data frame of the query.
}
\description{
Gets a query from a SQLite database.
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_query("SELECT date, posixct, factor FROM rws_data", conn = conn)
rws_disconnect(conn)
}
