% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{rws_read.character}
\alias{rws_read.character}
\title{Read Tables from a SQLite Database}
\usage{
\method{rws_read}{character}(x, meta = TRUE, conn, ...)
}
\arguments{
\item{x}{A character vector of table names.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{conn}{A \code{\linkS4class{SQLiteConnection}} to a database.}

\item{...}{Not used.}
}
\value{
A named list of the data frames.
}
\description{
Read Tables from a SQLite Database
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_write(rws_data[c("date", "ordered")], x_name = "data2", 
  exists = FALSE, conn = conn)
rws_read(c("rws_data", "data2"), conn = conn)
rws_disconnect(conn)
}
\seealso{
Other rws_read: \code{\link{rws_describe_meta.data.frame}},
  \code{\link{rws_read.SQLiteConnection}},
  \code{\link{rws_read}}
}
\concept{rws_read}
