% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_analysis.R
\name{add_feat_name}
\alias{add_feat_name}
\title{Append feature names to a \code{dana} object}
\usage{
add_feat_name(dana_obj, feat_names)
}
\arguments{
\item{dana_obj}{A \code{dana} object returned by \code{dana()}.}

\item{feat_names}{A data frame mapping \code{feat_id} to \code{feat_name}.
Must contain columns \code{"feat_id"} and \code{"feat_name"}.}
}
\value{
A modified version of \code{dana_obj}, with a \code{feat_name} column added to applicable components.
}
\description{
Adds a \code{feat_name} column to the \code{dana} object to map \code{feat_id} to original labels.
}
\examples{
set.seed(123)
mock_X <- matrix(rnorm(20 * 5), nrow = 20)
colnames(mock_X) <- paste0("feat_", seq_len(5))
rownames(mock_X) <- paste0("sample_", seq_len(20))

mock_names <- data.frame(
  feat_id = paste0("feat_", seq_len(5)),
  feat_name = c(
    "Glucose",
    "Lactic acid",
    "Citric acid",
    "Palmitic acid",
    "Cholesterol"
  ),
  stringsAsFactors = FALSE
)

sample_data <- data.frame(
  sample_id = rownames(mock_X),
  group = factor(rep(c("A", "B"), each = 10)),
  time = factor(rep(c("T1", "T2"), times = 10)),
  subject_id = factor(rep(seq_len(10), each = 2)),
  stringsAsFactors = FALSE
)
rownames(sample_data) <- sample_data$sample_id

fit_df <- data.frame(
  feat_id = rep(colnames(mock_X), each = 2),
  Coefficient = rep(c("(Intercept)", "groupB"), 5),
  Estimate = rnorm(10),
  `Pr(>|t|)` = runif(10),
  padj = runif(10),
  stringsAsFactors = FALSE
)

# Mock dana object
dana_obj <- list(
  X = mock_X,
  sdata = sample_data,
  formula_rhs = ~ group,
  fit = fit_df,
  lrt = data.frame(),
  ranef = data.frame()
)
class(dana_obj) <- "dana"

# Add fearure labels
dana_obj <- dana_obj |>
  add_feat_name(mock_names)

}
\seealso{
\code{\link[=dana]{dana()}} for fitting differential analysis models on omics datasets.
}
