library(rearrr)
context("position_*()")


test_that("fuzz testing position_max()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df_length <- 6
  df <- data.frame(
    "index" = 1:df_length,
    "A" = sample(1:df_length),
    "B" = runif(df_length),
    "C" = LETTERS[1:df_length],
    "G" = c(1, 1, 1, 2, 2,
            2),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'position_max'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = position_max,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, G), 1:10, -3:3, NA),
  #     "col" = list(NULL, "A", "B", "C"),
  #     "position" = list(2, 3, 4, 0, 7, NA),
  #     "shuffle_sides" = list(FALSE, TRUE)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'position_max'                                                   ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing position_max(data = df, col = NULL, position...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- position_max(data = df, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(4, 6, 5, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(3, 1, 4, 2, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["B"]],
    c(0.70506, 0.71911, 0.45774, 0.65699, 0.13467, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["C"]],
    c("D", "F", "E", "C", "B", "A"),
    fixed = TRUE)
  expect_equal(
    output_19148[["G"]],
    c(2, 2, 2, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = dplyr::group_by(df, G), ...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- position_max(data = dplyr::group_by(df, G), col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["index"]],
    c(1, 3, 2, 4, 6, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["A"]],
    c(6, 2, 5, 3, 1, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["B"]],
    c(0.73659, 0.65699, 0.13467, 0.70506, 0.71911, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["C"]],
    c("A", "C", "B", "D", "F", "E"),
    fixed = TRUE)
  expect_equal(
    output_19370[["G"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = 1:10, col = NULL, positi...
  # Changed from baseline: data = 1:10
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- position_max(data = 1:10, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12861),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "integer")
  # Testing values
  expect_equal(
    output_12861,
    c(8, 10, 9, 7, 6, 5, 4, 3, 2, 1),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    10L)

  # Testing position_max(data = -3:3, col = NULL, positi...
  # Changed from baseline: data = -3:3
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- position_max(data = -3:3, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_18304),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "integer")
  # Testing values
  expect_equal(
    output_18304,
    c(1, 3, 2, 0, -1, -2, -3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18304),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    7L)

  # Testing position_max(data = NA, col = NULL, position...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(position_max(data = NA, col = NULL, position = 2, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = NULL, col = NULL, positi...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(position_max(data = NULL, col = NULL, position = 2, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = df, col = "A", position ...
  # Changed from baseline: col = "A"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- position_max(data = df, col = "A", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["index"]],
    c(5, 1, 2, 4, 3, 6),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["A"]],
    c(4, 6, 5, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["B"]],
    c(0.45774, 0.73659, 0.13467, 0.70506, 0.65699, 0.71911),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["C"]],
    c("E", "A", "B", "D", "C", "F"),
    fixed = TRUE)
  expect_equal(
    output_17365[["G"]],
    c(2, 1, 1, 2, 1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = "B", position ...
  # Changed from baseline: col = "B"
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- position_max(data = df, col = "B", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["index"]],
    c(4, 1, 6, 3, 5, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["A"]],
    c(3, 6, 1, 2, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["B"]],
    c(0.70506, 0.73659, 0.71911, 0.65699, 0.45774, 0.13467),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["C"]],
    c("D", "A", "F", "C", "E", "B"),
    fixed = TRUE)
  expect_equal(
    output_11346[["G"]],
    c(2, 1, 2, 1, 2, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = "C", position ...
  # Changed from baseline: col = "C"
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- position_max(data = df, col = "C", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["index"]],
    c(4, 6, 5, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["A"]],
    c(3, 1, 4, 2, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["B"]],
    c(0.70506, 0.71911, 0.45774, 0.65699, 0.13467, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["C"]],
    c("D", "F", "E", "C", "B", "A"),
    fixed = TRUE)
  expect_equal(
    output_16569[["G"]],
    c(2, 2, 2, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(position_max(data = df, col = NULL, position = 0, shuffle_sides = FALSE), reset_seed = TRUE)
  # CHANGED: On some platforms, the 1e-20 is apparently converted to 1e020
  expect_true(
    xpectr::strip(side_effects_17050[['error']]) %in% c(
      xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Element 1 is not >= 1e-20\n * checkmate::check_count(position): Must be >= 1"),
      xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Element 1 is not >= 1e020\n * checkmate::check_count(position): Must be >= 1")
    ))
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = 7
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(position_max(data = df, col = NULL, position = 7, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("'position' was higher than the number of rows in 'data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(position_max(data = df, col = NULL, position = NA, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): May not be NA\n * checkmate::check_count(position): May not be NA"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- position_max(data = df, col = NULL, position = 3, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19346[["index"]],
    c(2, 4, 6, 5, 3, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["A"]],
    c(5, 3, 1, 4, 2, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["B"]],
    c(0.13467, 0.70506, 0.71911, 0.45774, 0.65699, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["C"]],
    c("B", "D", "F", "E", "C", "A"),
    fixed = TRUE)
  expect_equal(
    output_19346[["G"]],
    c(1, 2, 2, 2, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- position_max(data = df, col = NULL, position = 4, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["index"]],
    c(1, 2, 4, 6, 5, 3),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["A"]],
    c(6, 5, 3, 1, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["B"]],
    c(0.73659, 0.13467, 0.70506, 0.71911, 0.45774, 0.65699),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["C"]],
    c("A", "B", "D", "F", "E", "C"),
    fixed = TRUE)
  expect_equal(
    output_12554[["G"]],
    c(1, 1, 2, 2, 2, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: position = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(position_max(data = df, col = NULL, position = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Must be of type 'number', not 'NULL'\n * checkmate::check_count(position): Must be of type 'count', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: shuffle_sides = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- position_max(data = df, col = NULL, position = 2, shuffle_sides = TRUE)
  # Testing class
  expect_equal(
    class(output_19400),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19400[["index"]],
    c(4, 6, 5, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["A"]],
    c(3, 1, 4, 2, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["B"]],
    c(0.70506, 0.71911, 0.45774, 0.65699, 0.13467, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["C"]],
    c("D", "F", "E", "C", "B", "A"),
    fixed = TRUE)
  expect_equal(
    output_19400[["G"]],
    c(2, 2, 2, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19400),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19400),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19400),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19400),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19400)),
    character(0),
    fixed = TRUE)

  # Testing position_max(data = df, col = NULL, position...
  # Changed from baseline: shuffle_sides = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(position_max(data = df, col = NULL, position = 2, shuffle_sides = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'shuffle_sides': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'position_max'                                          ####
  #


})

test_that("fuzz testing position_min()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df_length <- 6
  df <- data.frame(
    "index" = 1:df_length,
    "A" = sample(1:df_length),
    "B" = runif(df_length),
    "C" = LETTERS[1:df_length],
    "G" = c(1, 1, 1, 2, 2,
            2),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'position_max'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = position_min,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, G), 1:10, -3:3, NA),
  #     "col" = list(NULL, "A", "B", "C"),
  #     "position" = list(2, 3, 4, 0, 7, NA),
  #     "shuffle_sides" = list(FALSE, TRUE)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'position_min'                                                   ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing position_min(data = df, col = NULL, position...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- position_min(data = df, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(3, 1, 2, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(2, 6, 5, 3, 4, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["B"]],
    c(0.65699, 0.73659, 0.13467, 0.70506, 0.45774, 0.71911),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["C"]],
    c("C", "A", "B", "D", "E", "F"),
    fixed = TRUE)
  expect_equal(
    output_19148[["G"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = dplyr::group_by(df, G), ...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- position_min(data = dplyr::group_by(df, G), col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["index"]],
    c(3, 1, 2, 6, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["A"]],
    c(2, 6, 5, 1, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["B"]],
    c(0.65699, 0.73659, 0.13467, 0.71911, 0.70506, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["C"]],
    c("C", "A", "B", "F", "D", "E"),
    fixed = TRUE)
  expect_equal(
    output_19370[["G"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = 1:10, col = NULL, positi...
  # Changed from baseline: data = 1:10
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- position_min(data = 1:10, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12861),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "integer")
  # Testing values
  expect_equal(
    output_12861,
    c(3, 1, 2, 4, 5, 6, 7, 8, 9, 10),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    10L)

  # Testing position_min(data = -3:3, col = NULL, positi...
  # Changed from baseline: data = -3:3
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- position_min(data = -3:3, col = NULL, position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_18304),
    "integer",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "integer")
  # Testing values
  expect_equal(
    output_18304,
    c(-1, -3, -2, 0, 1, 2, 3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18304),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    7L)

  # Testing position_min(data = NA, col = NULL, position...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(position_min(data = NA, col = NULL, position = 2, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = NULL, col = NULL, positi...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(position_min(data = NULL, col = NULL, position = 2, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = df, col = "A", position ...
  # Changed from baseline: col = "A"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- position_min(data = df, col = "A", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["index"]],
    c(4, 6, 3, 5, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["A"]],
    c(3, 1, 2, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["B"]],
    c(0.70506, 0.71911, 0.65699, 0.45774, 0.13467, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["C"]],
    c("D", "F", "C", "E", "B", "A"),
    fixed = TRUE)
  expect_equal(
    output_17365[["G"]],
    c(2, 2, 1, 2, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = "B", position ...
  # Changed from baseline: col = "B"
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- position_min(data = df, col = "B", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["index"]],
    c(3, 2, 5, 4, 6, 1),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["A"]],
    c(2, 5, 4, 3, 1, 6),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["B"]],
    c(0.65699, 0.13467, 0.45774, 0.70506, 0.71911, 0.73659),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["C"]],
    c("C", "B", "E", "D", "F", "A"),
    fixed = TRUE)
  expect_equal(
    output_11346[["G"]],
    c(1, 1, 2, 2, 2, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = "C", position ...
  # Changed from baseline: col = "C"
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- position_min(data = df, col = "C", position = 2, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["index"]],
    c(3, 1, 2, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["A"]],
    c(2, 6, 5, 3, 4, 1),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["B"]],
    c(0.65699, 0.73659, 0.13467, 0.70506, 0.45774, 0.71911),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["C"]],
    c("C", "A", "B", "D", "E", "F"),
    fixed = TRUE)
  expect_equal(
    output_16569[["G"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(position_min(data = df, col = NULL, position = 0, shuffle_sides = FALSE), reset_seed = TRUE)
  # CHANGED: On some platforms, the 1e-20 is apparently converted to 1e020
  expect_true(
    xpectr::strip(side_effects_17050[['error']]) %in% c(
      xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Element 1 is not >= 1e-20\n * checkmate::check_count(position): Must be >= 1"),
      xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Element 1 is not >= 1e020\n * checkmate::check_count(position): Must be >= 1")
    ))
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = 7
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(position_min(data = df, col = NULL, position = 7, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("'position' was higher than the number of rows in 'data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(position_min(data = df, col = NULL, position = NA, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): May not be NA\n * checkmate::check_count(position): May not be NA"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- position_min(data = df, col = NULL, position = 3, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19346[["index"]],
    c(5, 3, 1, 2, 4, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["A"]],
    c(4, 2, 6, 5, 3, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["B"]],
    c(0.45774, 0.65699, 0.73659, 0.13467, 0.70506, 0.71911),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["C"]],
    c("E", "C", "A", "B", "D", "F"),
    fixed = TRUE)
  expect_equal(
    output_19346[["G"]],
    c(2, 1, 1, 1, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = 4
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- position_min(data = df, col = NULL, position = 4, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["index"]],
    c(6, 5, 3, 1, 2, 4),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["A"]],
    c(1, 4, 2, 6, 5, 3),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["B"]],
    c(0.71911, 0.45774, 0.65699, 0.73659, 0.13467, 0.70506),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["C"]],
    c("F", "E", "C", "A", "B", "D"),
    fixed = TRUE)
  expect_equal(
    output_12554[["G"]],
    c(2, 2, 1, 1, 1, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: position = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(position_min(data = df, col = NULL, position = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_number(position): Must be of type 'number', not 'NULL'\n * checkmate::check_count(position): Must be of type 'count', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: shuffle_sides = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- position_min(data = df, col = NULL, position = 2, shuffle_sides = TRUE)
  # Testing class
  expect_equal(
    class(output_19400),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19400[["index"]],
    c(3, 1, 2, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["A"]],
    c(2, 6, 5, 3, 4, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["B"]],
    c(0.65699, 0.73659, 0.13467, 0.70506, 0.45774, 0.71911),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["C"]],
    c("C", "A", "B", "D", "E", "F"),
    fixed = TRUE)
  expect_equal(
    output_19400[["G"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19400),
    c("index", "A", "B", "C", "G"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19400),
    c("integer", "integer", "numeric", "character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19400),
    c("integer", "integer", "double", "character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19400),
    6:5)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19400)),
    character(0),
    fixed = TRUE)

  # Testing position_min(data = df, col = NULL, position...
  # Changed from baseline: shuffle_sides = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(position_min(data = df, col = NULL, position = 2, shuffle_sides = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'shuffle_sides': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'position_min'                                          ####
  #

})

test_that("position_max always have legal outputs()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df_length <- 6
  df <- data.frame(
    "index" = 1:df_length,
    "A" = sample(1:df_length),
    "B" = runif(df_length),
    "C" = LETTERS[1:df_length],
    "G" = c(1, 1, 1, 2, 2,
            2),
    stringsAsFactors = FALSE
  )

  xpectr::set_test_seed(42)
  orders <- plyr::ldply(seq_len(df_length), function(pos){
    plyr::ldply(1:10, function(rep){
      setNames(position_max(df, col = "A", position = pos, shuffle_sides = TRUE)$A,
               seq_len(df_length))
    }) %>%
      dplyr::mutate(pos = pos)
  }) %>% dplyr::distinct() %>%
    dplyr::as_tibble()


  ## Testing 'orders'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(orders),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    orders[["1"]],
    c(6, 4, 5, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    orders[["2"]],
    c(5, 6, 6, 4, 5, 5, 4, 3, 3, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    orders[["3"]],
    c(4, 5, 4, 6, 6, 6, 6, 5, 4, 5, 4, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    orders[["4"]],
    c(3, 3, 3, 5, 4, 4, 5, 6, 6, 6, 6, 5, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    orders[["5"]],
    c(2, 2, 2, 3, 3, 2, 2, 4, 5, 4, 5, 6, 6, 5),
    tolerance = 1e-4)
  expect_equal(
    orders[["6"]],
    c(1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 3, 4, 5, 6),
    tolerance = 1e-4)
  expect_equal(
    orders[["pos"]],
    c(1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(orders),
    c("1", "2", "3", "4", "5", "6", "pos"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(orders),
    c("integer", "integer", "integer", "integer", "integer", "integer",
      "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(orders),
    c("integer", "integer", "integer", "integer", "integer", "integer",
      "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(orders),
    c(14L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(orders)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'orders'                                              ####

})

test_that("position_min always have legal outputs()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df_length <- 6
  df <- data.frame(
    "index" = 1:df_length,
    "A" = sample(1:df_length),
    "B" = runif(df_length),
    "C" = LETTERS[1:df_length],
    "G" = c(1, 1, 1, 2, 2,
            2),
    stringsAsFactors = FALSE
  )

  xpectr::set_test_seed(42)
  # TODO Convert to purrr call so we don't need
  # to suggest plyr
  orders <- plyr::ldply(seq_len(df_length), function(pos){
    plyr::ldply(1:10, function(rep){
      setNames(position_min(df, col = "A", position = pos, shuffle_sides = TRUE)$A,
               seq_len(df_length))
    }) %>%
      dplyr::mutate(pos = pos)
  }) %>% dplyr::distinct() %>%
    dplyr::as_tibble()


  ## Testing 'orders'                                                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(orders),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    orders[["1"]],
    c(1, 3, 2, 5, 5, 4, 4, 6, 6, 6, 6, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    orders[["2"]],
    c(2, 1, 1, 3, 2, 2, 3, 4, 4, 5, 5, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    orders[["3"]],
    c(3, 2, 3, 1, 1, 1, 1, 2, 3, 2, 3, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    orders[["4"]],
    c(4, 4, 4, 2, 3, 3, 2, 1, 1, 1, 1, 2, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    orders[["5"]],
    c(5, 5, 5, 4, 4, 5, 5, 3, 2, 3, 2, 1, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    orders[["6"]],
    c(6, 6, 6, 6, 6, 6, 6, 5, 5, 4, 4, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    orders[["pos"]],
    c(1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(orders),
    c("1", "2", "3", "4", "5", "6", "pos"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(orders),
    c("integer", "integer", "integer", "integer", "integer", "integer",
      "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(orders),
    c("integer", "integer", "integer", "integer", "integer", "integer",
      "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(orders),
    c(14L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(orders)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'orders'                                              ####

})

