% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_generated.R
\name{GeneratedTransformation}
\alias{GeneratedTransformation}
\title{GeneratedTransformation}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Container for the type of transformation used in
\code{\link[rearrr:GeneratedPipeline]{GeneratedPipeline}}.

\strong{Note}: For internal use.
}
\seealso{
Other transformation classes: 
\code{\link{FixedGroupsTransformation}},
\code{\link{Transformation}}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{transformation classes}
\section{Super class}{
\code{\link[rearrr:Transformation]{rearrr::Transformation}} -> \code{GeneratedTransformation}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Name of transformation.}

\item{\code{fn}}{Transformation function.}

\item{\code{args}}{\code{list} of constant arguments for \code{`fn`}.}

\item{\code{generators}}{\code{list} of generator functions
for generating argument values.}

\item{\code{apply_generator}}{Generator function for deciding
whether to apply the transformation to the current group.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GeneratedTransformation$new()}}
\item \href{#method-get_group_args}{\code{GeneratedTransformation$get_group_args()}}
\item \href{#method-generate_args}{\code{GeneratedTransformation$generate_args()}}
\item \href{#method-print}{\code{GeneratedTransformation$print()}}
\item \href{#method-clone}{\code{GeneratedTransformation$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rearrr" data-topic="Transformation" data-id="apply">}\href{../../rearrr/html/Transformation.html#method-apply}{\code{rearrr::Transformation$apply()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeneratedTransformation$new(
  fn,
  args,
  generators,
  name = NULL,
  group_cols = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Transformation function.}

\item{\code{args}}{\code{list} of constant arguments for \code{`fn`}.}

\item{\code{generators}}{Named \code{list} of functions for generating argument values
for a single call of \code{`fn`}.

It is possible to include an \emph{apply generator} for deciding whether
the transformation should be applied to the current group or not.
This is done by adding a function with the name \code{`.apply`} to the \code{`generators`} list.
E.g. \code{".apply" = function(){sample(c(TRUE, FALSE), 1)}}.}

\item{\code{name}}{Name of transformation.}

\item{\code{group_cols}}{Names of columns to group \code{data.frame}
by before applying \code{`fn`}.

When \code{`NULL`}, the \code{data.frame} is not grouped.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_group_args"></a>}}
\if{latex}{\out{\hypertarget{method-get_group_args}{}}}
\subsection{Method \code{get_group_args()}}{
Get arguments for a group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeneratedTransformation$get_group_args()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of arguments (both constant and generated).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generate_args"></a>}}
\if{latex}{\out{\hypertarget{method-generate_args}{}}}
\subsection{Method \code{generate_args()}}{
Generate arguments for a group with the \code{`generators`}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeneratedTransformation$generate_args()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of generated arguments.

Does not include the constant arguments.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print an overview of the transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeneratedTransformation$print(..., indent = 0, show_class = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments passed to or from other methods.}

\item{\code{indent}}{How many spaces to indent when printing.}

\item{\code{show_class}}{Whether to print the transformation class name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The pipeline. To allow chaining of methods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GeneratedTransformation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
