% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouping-and-repetition.R
\name{char_class}
\alias{char_class}
\alias{negate_and_group}
\alias{negated_char_class}
\title{A range or char_class of characters}
\usage{
char_class(...)

negated_char_class(...)

negate_and_group(...)
}
\arguments{
\item{...}{Character vectors.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Group characters together in a class to match any of them (\code{char_class})
or none of them (\code{negated_char_class}).
}
\examples{
char_class(LOWER, "._")
negated_char_class(LOWER, "._")

# Usage
x <- (1:10) ^ 2
(rx_odd <- char_class(1, 3, 5, 7, 9))
(rx_not_odd <- negated_char_class(1, 3, 5, 7, 9))
stringi::stri_detect_regex(x, rx_odd)
stringi::stri_detect_regex(x, rx_not_odd)
}
\references{
\url{http://www.regular-expressions.info/charclass.html}
}

