% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datetime.R
\docType{data}
\name{DateTime}
\alias{AM_PM}
\alias{CENTURY}
\alias{DAY}
\alias{DAY_OF_YEAR}
\alias{DAY_SINGLE}
\alias{DMY}
\alias{DTSEP}
\alias{DYM}
\alias{DateTime}
\alias{FRACTIONAL_SECOND}
\alias{HM}
\alias{HMS}
\alias{HOUR12}
\alias{HOUR12_SINGLE}
\alias{HOUR24}
\alias{HOUR24_SINGLE}
\alias{ISO_DATE}
\alias{ISO_DATETIME}
\alias{ISO_TIME}
\alias{MDY}
\alias{MINUTE}
\alias{MONTH}
\alias{MS}
\alias{MYD}
\alias{SECOND}
\alias{TIMEZONE}
\alias{TIMEZONE_OFFSET}
\alias{WEEKDAY0}
\alias{WEEKDAY1}
\alias{WEEK_OF_YEAR}
\alias{YDM}
\alias{YEAR}
\alias{YEAR2}
\alias{YEAR4}
\alias{YMD}
\alias{datetime}
\title{Date-time regexes}
\format{\preformatted{Classes 'regex', 'character'  chr "[-/.:,\\\\ ]?"
}}
\usage{
DTSEP

CENTURY

YEAR

YEAR2

YEAR4

MONTH

WEEK_OF_YEAR

DAY

DAY_SINGLE

DAY_OF_YEAR

WEEKDAY1

WEEKDAY0

HOUR24

HOUR12

HOUR24_SINGLE

HOUR12_SINGLE

MINUTE

SECOND

FRACTIONAL_SECOND

AM_PM

TIMEZONE_OFFSET

TIMEZONE

ISO_DATE

ISO_TIME

ISO_DATETIME

YMD

YDM

MYD

MDY

DYM

DMY

HMS

HM

MS

datetime(x, locale = NULL)
}
\arguments{
\item{x}{A \code{\link[base]{strptime}}-style date-time format string.}

\item{locale}{A string specifying a locale.}
}
\description{
Compound regex constants for matching ISO 8601 dates and times.
}
\examples{
datetime("\%m/\%d/\%Y")             # match US style dates
datetime(group("\%H" \%|\% "\%I\%p")) # match hours in 24h or 12h format

\dontrun{
# week days and months are can be matched in any locale
if(.Platform$OS.type == "windows")
{
  fr_FR <- "French_France"
  ar_QA <- "Arabic_Qatar"
} else
{
  fr_FR <- "fr_FR.utf8"
  ar_QA <- "ar_QA.utf8"
}
datetime("\%a \%A \%b \%B", fr_FR)
datetime("\%a \%A \%b \%B", ar_QA)

# All letter tokens.  Lots of output.
x <- paste0("\%", c(letters, LETTERS))
setNames(datetime(x), x)
}

# Individual date-time components
DTSEP             # optional selected punctuation or space
CENTURY           # exactly two digits
YEAR              # one to four digits
YEAR2             # exactly two digits
YEAR4             # exactly four digits
MONTH             # number from 1 to 12, leading zero
WEEK_OF_YEAR      # number from 0 to 53, leading zero
DAY               # number from 1 to 31, leading zero
DAY_SINGLE        # optional leading space
HOUR24            # 24 hour clock, leading zero
HOUR12            # 12 hour clock, leading zero
HOUR24_SINGLE     # 24 hour clock, optional leading space
HOUR12_SINGLE     # 12 hour clock, optional leading space
MINUTE            # number from 0 to 59, leading zero
SECOND            # number from 0 to 61 (leap seconds), leading zero
FRACTIONAL_SECOND # a second optional decimal point and up to 6 digits
AM_PM             # AM or PM, any case
TIMEZONE_OFFSET   # optional plus or minus, then four digits
TIMEZONE          # Any value returned by OlsonNames()
# ISO 8601 formats
ISO_DATE          # \%Y-\%m-\%d
ISO_TIME          # \%H:\%M:\%S
ISO_DATETIME      # ISO_DATE followed by ISO_TIME, separated by space or "T".
# Compound forms, separated by DTSEP
YMD
YDM
MYD
MDY
DYM
DMY
HMS
HM
MS

dates <- seq(as.Date("2000-01-01"), as.Date("2001-01-01"), "1 day")
datetimes <- seq(as.POSIXct(Sys.Date()), as.POSIXct(Sys.Date() + 1), "1 sec")
times <- substring(datetimes, 12, 19)
stopifnot(
  all(grepl(ISO_DATE, dates)),
  all(grepl(ISO_TIME, times)),
  all(grepl(ISO_DATETIME, datetimes))
)
non_dates <- c(
  "2000-13-01", "2000-01-32", "2000-00-01", "2000-01-00"
)
non_times <- c(
  "24:00:00", "23:60:59", "23:59:62", "23 59 59"
)
stopifnot(
  all(!grepl(ISO_DATE, non_dates)),
  all(!grepl(ISO_TIME, non_times))
)
}
\seealso{
\code{\link{ClassGroups}}, \code{\link[base]{Sys.setlocale}}
}
\keyword{datasets}

