% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowerimpute.R
\name{step_lowerimpute}
\alias{step_lowerimpute}
\alias{tidy.step_lowerimpute}
\title{Impute Numeric Data Below the Threshold of Measurement}
\usage{
step_lowerimpute(recipe, ..., role = NA, trained = FALSE,
  threshold = NULL, skip = FALSE)

\method{tidy}{step_lowerimpute}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{threshold}{A named numeric vector of lower bounds This is
\code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{x}{A \code{step_lowerimpute} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} for the estimated
threshold.
}
\description{
\code{step_lowerimpute} creates a \emph{specification} of a recipe step
designed for cases where the non-negative numeric data cannot be
measured below a known value. In these cases, one method for
imputing the data is to substitute the truncated value by a
random uniform number between zero and the truncation point.
}
\details{
\code{step_lowerimpute} estimates the variable minimums
from the data used in the \code{training} argument of \code{prep.recipe}.
\code{bake.recipe} then simulates a value for any data at the minimum
with a random uniform value between zero and the minimum.
}
\examples{
library(recipes)
data(biomass)

## Truncate some values to emulate what a lower limit of
## the measurement system might look like

biomass$carbon <- ifelse(biomass$carbon > 40, biomass$carbon, 40)
biomass$hydrogen <- ifelse(biomass$hydrogen > 5, biomass$carbon, 5)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

impute_rec <- rec \%>\%
  step_lowerimpute(carbon, hydrogen)

tidy(impute_rec, number = 1)

impute_rec <- prep(impute_rec, training = biomass_tr)

tidy(impute_rec, number = 1)

transformed_te <- bake(impute_rec, biomass_te)

plot(transformed_te$carbon, biomass_te$carbon,
     xlab = "pre-imputation", ylab = "imputed")
}
\concept{
preprocessing imputation
}
\keyword{datagen}
