% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{deleteRuns}
\alias{deleteRuns}
\alias{deleteRuns,Recordr-method}
\title{Delete runs that match search parameters}
\usage{
deleteRuns(recordr, ...)

\S4method{deleteRuns}{Recordr}(recordr, id = as.character(NA),
  file = as.character(NA), start = as.character(NA),
  end = as.character(NA), tag = as.character(NA),
  error = as.character(NA), seq = as.integer(NA), noop = FALSE,
  quiet = FALSE)
}
\arguments{
\item{recordr}{A Recordr instance}

\item{...}{additional arguments}

\item{id}{An execution identifier}

\item{file}{The name of script to match.}

\item{start}{A one or two element character list specifying a date range to match for run start time}

\item{end}{A one or tow element character list specifying a date range to match for run end time}

\item{tag}{The text of the tags to match.}

\item{error}{The text of the error message to match.}

\item{seq}{The run sequence number (can be a single value or a range, e.g \code{seq="1:10"})}

\item{noop}{Don't delete any date, just show what would be deleted.}

\item{quiet}{A \code{logical} if TRUE then output is not printed. Useful if only the return value is desired.}
}
\value{
A data.frame containing execution metadata for the runs that were deleted.
}
\description{
The execution metadata and all archived files associated with
each matching run are permanently deleted from the file system. No backup is maintained
by the recordr package, so this deletion is irreversible, unless the user
maintains their own backup.
}
\seealso{
\code{\link[=Recordr-class]{Recordr}}{ class description}
}

