% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{viewRuns}
\alias{viewRuns}
\alias{viewRuns,Recordr-method}
\title{View detailed information for an execution}
\usage{
viewRuns(recordr, ...)

\S4method{viewRuns}{Recordr}(recordr, id = as.character(NA),
  file = as.character(NA), start = as.character(NA),
  end = as.character(NA), tag = as.character(NA),
  error = as.character(NA), seq = as.character(NA),
  orderBy = "-startTime", sections = c("details", "used", "generated"),
  verbose = FALSE, page = TRUE, output = TRUE)
}
\arguments{
\item{recordr}{A Recordr instance}

\item{...}{additional parameter}

\item{id}{The execution identifier of a run to view}

\item{file}{The name of script to match}

\item{start}{Match runs that started in this time range (inclusive)
Times must be entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to not less that "YYYY"}

\item{end}{Match runs that ended in this time range (inclusive)
Times must be entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to not less that "YYYY"}

\item{tag}{The text of tag to match}

\item{error}{The text of error message to match.}

\item{seq}{A run sequence number (can be a range, e.g \code{seq=1:10})}

\item{orderBy}{Sort the results according to the specified column. A hypen ('-') prepended to the column name 
denoes a descending sort. The default value is "-startTime"}

\item{sections}{Print the specified sections of the output. Default=c("details", "used", "generated")}

\item{verbose}{a \code{"logical"}, if TRUE then extra information is printed.}

\item{page}{A logical value - if TRUE then pause after each run is displayed.}

\item{output}{a \code{"logical"}, if FALSE then no output is printed to the console (useful if only the returned object is needed).}
}
\value{
A list that contains information about all selected runs.
}
\description{
Detailed information for an execution is printed to the display.
}
\details{
The execution and file information for runs that match the search criteria are 
printed to the console. The output is divided into three sections: "details", "used"
and "generated". The "details" section shows execution information such as the start and end time
of the run, run identifier, etc. The "used" section lists files that were read by a run. The
"generated" section lists files that were created by a run. The list that is returned from \code{"viewRuns"}
contains two elements - a data.frame with the execution information, and a data.frame that contains
file information.
}
\examples{
\dontrun{
rc <- new("Recordr")
# View the tenth run that was recorded
viewRuns(rc, seq=10)
# View the first ten runs, with only the files "generated" section displayed
info <- viewRuns(rc, seq="1:10", sections="generated")
nrow(info$runs)
nrow(info$files)
}
}
\seealso{
\code{\link[=Recordr-class]{Recordr}} { class description}
}

