% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{map.habitat}
\alias{map.habitat}
\title{Map species distribution of habitat specialist.}
\usage{
map.habitat(longlat, layer, polygon = TRUE, eval = TRUE)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude (two columns) of each occurrence record.}

\item{layer}{RasterLayer object representing the distribution of a single habitat.}

\item{polygon}{If TRUE, all habitat patches inside the minimum convex hull polygon encompassing all occurrence records are converted to presence.}

\item{eval}{Build a matrix with EOO (from raw data), EOO (from model), AOO (from raw data) and AOO (from model).}
}
\value{
One raster file and possibly a matrix with EOO (from raw data), EOO (from model), AOO (from raw data) and AOO (from model).
}
\description{
Mapping of all habitat areas where the species is known to occur.
}
\details{
In many cases a species has a very restricted habitat and we generally know where it occurs. In such cases using the distribution of the habitat patches may be enough to map the species.
}

