% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/allocationTable.R, R/allocationTable_offline.R
\name{allocationTable}
\alias{allocationTable}
\alias{allocationTable.redcapApiConnection}
\alias{allocationTable.redcapDbConnection}
\alias{allocationTable_offline}
\title{Allocation Tables for the Randomization Module}
\usage{
allocationTable(rcon, random, strata = NULL, group = NULL, dag.id = NULL,
  replicates, block.size, block.size.shift = 0, seed.dev = NULL,
  seed.prod = NULL, proj = NULL, ...)

\method{allocationTable}{redcapDbConnection}(rcon, random, strata = NULL,
  group = NULL, dag.id = NULL, replicates, block.size,
  block.size.shift = 0, seed.dev = NULL, seed.prod = NULL, proj = NULL,
  ...)

\method{allocationTable}{redcapApiConnection}(rcon, random, strata = NULL,
  group = NULL, dag.id = NULL, replicates, block.size,
  block.size.shift = 0, seed.dev = NULL, seed.prod = NULL, proj = NULL,
  ...)

allocationTable_offline(meta_data, random, strata = NULL, group = NULL,
  dag.id = NULL, replicates, block.size, block.size.shift = 0,
  seed.dev = NULL, seed.prod = NULL, ...)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{random}{The field name to be randomized.}

\item{strata}{Field names by which to stratify the randomization.}

\item{group}{A field name giving a group by which randomization should be
stratified.  This could also be listed in \code{strata}, but the argument
is provided to remain consistent with the REDCap user interface.}

\item{dag.id}{Data Access Group IDs.  See the package wiki for instructions
on how to get the ID's. (They cannot currently be accessed via the API)}

\item{replicates}{The number of randomizations to perform within each stratum}

\item{block.size}{Block size for the randomization.  Blocking is recommended
to ensure balanced groups throughout the randomization.  This may be a vector
to indicate variable block sizes throughout the randomization.}

\item{block.size.shift}{A vector the same length as \code{block.size} where the
first element is 0.  This controls when the block size changes as a proportion
of the total sample size.  When \code{block.size=c(8, 4, 2)} and
\code{block.size.shift = c(0, .5, .9)}, the first half of the randomization
is performed in blocks of 8, then the next 40 percent of the randomization
is performed in blocks of 4, with the last 10 percent performed in blocks
of 2.}

\item{seed.dev}{At least one value is required.  If only one value is given,
it will be converted to a vector with length equal to the number of strata.
Values will be incremented by 100 to provide independent randomizations.
This may also have length equal to the number of strata.}

\item{seed.prod}{Same as \code{seed.prod}, but used to seed the production
allocation.  No pairwise elements of \code{seed.dev} and \code{seed.prod}
may be equal.  This guarantees that the two randomization schemes are
unique.}

\item{proj}{A \code{redcapProjectInfo} object.}

\item{...}{Arguments to be passed to other methods}

\item{meta_data}{A text string giving the location of the data
dictionary downloaded from REDCap.}
}
\description{
Generate allocation table for the REDCap
randomization module. Randomization may be stratified by other
(categorical) variables in the data set as well as by data
access group.  Additionally, randomization may be blocked
to ensure balanced groups throughout the allocation
}
\details{
Each element in \code{block.size} must be a multiple of the number of groups in the randomized
variable.

The 'offline' version of the function operates on the data dictionary file downloaded from
REDCap.  This is made available for instances where the
API can not be accessed for some reason (such as waiting for API approval
from the REDCap administrator).

The value of \code{replicates} controls how many allocations are generated.  It
is possible to get slightly more replicates than requested if your blocking design
cannot exactly match replicates.  For example, if you as for 30 replicates in
blocks of 8, a warning will be printed and you will receive 32 replicates in the
randomization table.
}
\author{
Benjamin Nutter
}
\references{
More instruction on using \code{redcapAPI} to produce allocation tables is
  on the package wiki:
  \url{https://github.com/nutterb/redcapAPI/wiki/Randomization-Module}

Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}

