% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportMetaData.R
\name{exportMetaData}
\alias{exportMetaData}
\alias{exportMetaData.redcapDbConnection}
\alias{exportMetaData.redcapApiConnection}
\title{Export Meta Data from a REDCap Database}
\usage{
exportMetaData(rcon, ...)

\method{exportMetaData}{redcapDbConnection}(rcon, ...)

\method{exportMetaData}{redcapApiConnection}(
  rcon,
  fields = NULL,
  forms = NULL,
  error_handling = getOption("redcap_error_handling"),
  ...,
  drop_utf8 = FALSE
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection.}}

\item{...}{Arguments to be passed to other methods.}

\item{fields}{A character vector of field names for which the metadata is to 
be retrieved.}

\item{forms}{A character vector of forms for which the metadata is to be
retrieved. Note that if a form name is given, all of the fields on that form
will be returned, regardless of whether it is included in \code{fields} or 
not.  Be careful to use the form names in the second column of the data 
dictionary, and not the display names shown on the webpage.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{drop_utf8}{\code{logical(1)}. In some cases, UTF-8 characters can 
pose problems for exporting the data dictionary.  Set this to \code{TRUE}
to replace any UTF-8 characters with empty characters.}
}
\description{
Retrieves the meta data for a REDcap database, including 
field names, labels, types, formulas, etc.  This file can be used to parse 
levels of factors, apply labels, and other data management tasks once the 
data are retrieved
}
\details{
A record of this export is placed in the REDCap logging page, 
but the file that is exported is not stored in the database.
}
\section{REDCap API Documentation}{

This function allows you to export the metadata for a project
}

\section{REDCap Version}{

5.8.2+ (and earlier, but we don't know how much earlier)
}

\section{Known REDCap Limitations}{
 
The API doesn't respond to the \code{fields} and \code{forms} arguments.  It
always returns the full data dictionary.
}

\references{
This functionality was originally developed by Jeffrey Horner in the \code{redcap} package.
\url{https://github.com/vubiostat/redcap}

Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Jeffrey Horner
}
