% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFiles.R
\name{importFiles}
\alias{importFiles}
\alias{importFiles.redcapApiConnection}
\title{Imports a File to REDCap to Attach to a Record}
\usage{
importFiles(
  rcon,
  file,
  record,
  field,
  event,
  overwrite = TRUE,
  ...,
  bundle = NULL,
  repeat_instance = NULL
)

\method{importFiles}{redcapApiConnection}(
  rcon,
  file,
  record,
  field,
  event = NULL,
  overwrite = TRUE,
  repeat_instance = NULL,
  ...,
  bundle = NULL,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{file}{Character string giving the file path to the file to be imported.}

\item{record}{The record ID in which the desired file is stored. Must be length 1.}

\item{field}{The field name in which the file is stored. Must be length 1.}

\item{event}{The event name for the file.  Must be length 1.  This applies 
only to longitudinal projects.  If the event is not supplied for a 
longitudinal project, the API will return an error}

\item{overwrite}{Logical.  When \code{FALSE}, the function checks if a 
file already exists for that record.  If a file exists, the function 
terminates to prevent overwriting.  When \code{TRUE}, no additional 
check is performed.}

\item{...}{Arguments to be passed to other methods}

\item{bundle}{A \code{redcapBundle} object as created by \code{exportBundle}.}

\item{repeat_instance}{The repeat instance number of the repeating
event or the repeating instrument. When available in your instance
of REDCap, and passed as NULL, the API will assume a value of 1.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
A single file may be attached to a single record.  The 
  behavior of this function is consistent with the
  behavior of the API, which only allows one file to be uploaded at a time
}
\details{
The function may only import a single file
}
\author{
Benjamin Nutter
}
