% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportPDF.R
\name{exportPdf}
\alias{exportPdf}
\alias{exportPdf.redcapApiConnection}
\title{Export PDF file of Data Collection Instruments}
\usage{
exportPdf(
  rcon,
  dir,
  filename = "redcap_forms_download",
  record = NULL,
  events = NULL,
  instruments = NULL,
  all_records = FALSE,
  ...
)

\method{exportPdf}{redcapApiConnection}(
  rcon,
  dir,
  filename = "redcap_forms_download",
  record = NULL,
  events = NULL,
  instruments = NULL,
  all_records = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{dir}{\code{character(1)}. The directory into which the file
should be saved.}

\item{filename}{\code{character(1)}. The base of the file name.  When
\code{record = NULL}, it will be appended with \code{"_blank.pdf"}.  When
\code{record} has a value, it will be appended with \code{"_record_[record id].pdf"}}

\item{record}{\code{character(1)}, \code{integerish(1)}, or \code{NULL}.
The record id for which forms should be downloaded.}

\item{events}{\code{character}. The events for which forms should be downloaded}

\item{instruments}{\code{character}. The instruments for which forms
should be downloaded}

\item{all_records}{\code{logical(1)}. When \code{TRUE} forms for all records
are downloaded. When \code{TRUE}, this overrides the \code{records} argument.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportPdf} has no return. After saving the file to the local
computer, a message is displayed providing the location of the file
on the system.
}
\description{
These methods allow the user to download PDF files of
data collection instruments.  The download may be with or without
collected data; and may return a single record, multiple records,
or all records.
}
\details{
These methods mimics the behavior of "Download PDF of Instruments" button on the
REDCap user interface. They permit the user to export a PDF file for:
\enumerate{
\item A single collection instrument (blank)c
\item All instruments (blank)
\item A single instrument (with data from a single record)c
\item All instruments (with data from a single record)
\item All instruments (with data from all records)
}
}
\seealso{
\code{\link[=exportMetaData]{exportMetaData()}},\cr
\code{\link[=importMetaData]{importMetaData()}}, \cr
\code{\link[=exportFieldNames]{exportFieldNames()}}, \cr
\code{\link[=exportInstruments]{exportInstruments()}},\cr
\code{\link[=exportMappings]{exportMappings()}},\cr
\code{\link[=importMappings]{importMappings()}}
}
