% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.calc.frontier.size}
\alias{redist.calc.frontier.size}
\title{Calculate Frontier Size}
\usage{
redist.calc.frontier.size(ordered_path)
}
\arguments{
\item{ordered_path}{path to ordered path created by redist.prep.enumpart}
}
\value{
List, four objects
\itemize{
\item{max}{numeric, maximum frontier size}
\item{average}{numeric, average frontier size}
\item{average_sq}{numeric, average((frontier size)^2)}
\item{sequence}{numeric vector, lists out all sizes for every frontier}
}
}
\description{
Calculate Frontier Size
}
\examples{
\dontrun{
data(fl25)
adj <- redist.adjacency(fl25)
redist.prep.enumpart(adj, 'unordered', 'ordered')
redist.calc.frontier.size('ordered')
}
}
