% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_ms_parallel.R
\name{redist_mergesplit_parallel}
\alias{redist_mergesplit_parallel}
\title{Parallel Merge-Split/Recombination MCMC Redistricting Sampler}
\usage{
redist_mergesplit_parallel(
  map,
  nsims,
  chains = 1,
  warmup = floor(nsims/2),
  init_plan = NULL,
  counties = NULL,
  compactness = 1,
  constraints = list(),
  constraint_fn = function(m) rep(0, ncol(m)),
  adapt_k_thresh = 0.975,
  k = NULL,
  ncores = NULL,
  cl_type = "PSOCK",
  return_all = TRUE,
  init_name = NULL,
  verbose = TRUE,
  silent = FALSE
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{nsims}{The number of samples to draw, including warmup.}

\item{chains}{the number of parallel chains to run. Each chain will have
\code{nsims} draws. If \code{init_plan} is sampled, each chain will be initialized
with its own sampled plan.}

\item{warmup}{The number of warmup samples to discard.}

\item{init_plan}{The initial state of the map, provided as a single vector
to be shared across all chains, or a matrix with \code{chains} columns.
If not provided, will default to the reference map of the map object, or if
none exists, will sample a random initial state using redist_smc. You can
also request a random initial state for each chain by setting
init_plan="sample".}

\item{counties}{A vector containing county (or other administrative or
geographic unit) labels for each unit, which may be integers ranging from 1
to the number of counties, or a factor or character vector.  If provided, the
algorithm will generate maps tend to follow county lines.  You may combine this
with a Gibbs constraint on the number of county splits using the
\code{constraints} parameter; see below. If no county-split considerations
are desired, this parameter should be left blank.}

\item{compactness}{Controls the compactness of the generated districts, with
higher values preferring more compact districts. Must be nonnegative. See the
'Details' section for more information, and computational considerations.}

\item{constraints}{A list containing information on constraints to implement.
See the 'Details' section for more information.}

\item{constraint_fn}{A function which takes in a matrix where each column is
a redistricting plan and outputs a vector of log-weights, which will be
added the the final weights.}

\item{adapt_k_thresh}{The threshold value used in the heuristic to select a
value \code{k_i} for each splitting iteration. Set to 0.9999 or 1 if
the algorithm does not appear to be sampling from the target distribution.
Must be between 0 and 1.}

\item{k}{The number of edges to consider cutting after drawing a spanning
tree. Should be selected automatically in nearly all cases.}

\item{ncores}{the number of parallel processes to run. Defaults to the
maximum available.}

\item{cl_type}{the cluster type (see \code{\link[=makeCluster]{makeCluster()}}). Safest is \code{"PSOCK"},
but \code{"FORK"} may be appropriate in some settings.}

\item{return_all}{if \code{TRUE} return all sampled plans; otherwise, just return
the final plan from each chain.}

\item{init_name}{a name for the initial plan, or \code{FALSE} to not include
the initial plan in the output.  Defaults to the column name of the
existing plan, or "\code{<init>}" if the initial plan is sampled.}

\item{verbose}{Whether to print out intermediate information while sampling.
Recommended.}

\item{silent}{Whether to suppress all diagnostic information.}
}
\value{
A \code{\link{redist_plans}} object with all of the simulated plans, and an
additional \code{chain} column indicating the chain the plan was drawn from.
}
\description{
\code{redist_mergesplit_parallel()} runs \code{\link[=redist_mergesplit]{redist_mergesplit()}} on several
chains in parallel.
}
\details{
This function draws samples from a specific target measure, controlled by the
\code{compactness}, \code{constraints}, and \code{constraint_fn} parameters.

Higher values of \code{compactness} sample more compact districts;
setting this parameter to 1 is computationally efficient and generates nicely
compact districts.

The \code{constraints} parameter allows the user to apply several common
redistricting constraints without implementing them by hand. This parameter
is a list, which may contain any of the following named entries:
\itemize{
\item \code{status_quo}: a list with two entries:
\itemize{
\item \code{strength}, a number controlling the tendency of the generated districts
to respect the status quo, with higher values preferring more similar
districts.
\item \code{current}, a vector containing district assignments for
the current map.
}
\item \code{hinge}: a list with three entries:
\itemize{
\item \code{strength}, a number controlling the strength of the Voting Rights Act
(VRA) constraint, with higher values prioritizing majority-minority districts
over other considerations.
\item \code{tgts_min}, the target percentage(s) of minority voters in minority
opportunity districts. Defaults to \code{c(0.55)}.
\item \code{min_pop}, A vector containing the minority population of each
geographic unit.
}
\item \code{incumbency}: a list with two entries:
\itemize{
\item \code{strength}, a number controlling the tendency of the generated districts
to avoid pairing up incumbents.
\item \code{incumbents}, a vector of precinct indices, one for each incumbent's
home address.
}
\item \code{splits}: a list with one entry:
\itemize{
\item \code{strength}, a number controlling the tendency of the generated districts
to avoid splitting counties.
}
\item \code{multisplits}: a list with one entry:
\itemize{
\item \code{strength}, a number controlling the tendency of the generated districts
to avoid splitting counties multiple times.
}
\item \code{vra}: a list with five entries, which may be set up using
\code{\link{redist.constraint.helper}}:
\itemize{
\item \code{strength}, a number controlling the strength of the Voting Rights Act
(VRA) constraint, with higher values prioritizing majority-minority districts
over other considerations.
\item \code{tgt_vra_min}, the target percentage of minority voters in minority
opportunity districts. Defaults to 0.55.
\item \code{tgt_vra_other} The target percentage of minority voters in other
districts. Defaults to 0.25, but should be set to reflect the total minority
population in the state.
\item \code{pow_vra}, which controls the allowed deviation from the target
minority percentage; higher values are more tolerant. Defaults to 1.5
\item \code{min_pop}, A vector containing the minority population of each
geographic unit.
}
}

All constraints are fed into a Gibbs measure, with coefficients on each
constraint set by the corresponding \code{strength} parameters.
The strength can be any real number, with zero corresponding to no constraint.
The \code{status_quo} constraint adds a term measuring the variation of
information distance between the plan and the reference, rescaled to [0, 1].
The \code{hinge} constraint takes a list of target minority percentages. It
matches each district to its nearest target percentage, and then applies a
penalty of the form \eqn{\sqrt{max(0, tgt - minpct)}}, summing across
districts. This penalizes districts which are below their target population.
The \code{incumbency} constraint adds a term counting the number of districts
containing paired-up incumbents. The \code{splits} constraint adds a term
counting the number of counties which contain precincts belonging to more
than one district.
The \code{vra} constraint (not recommended) adds a term of the form
\eqn{(|tgtvramin-minpct||tgtvraother-minpct|)^{powvra})}, which
encourages districts to have minority percentages near either \code{tgt_vra_min}
or \code{tgt_vra_other}. This can be visualized with
\code{\link{redist.plot.penalty}}.
}
\examples{
\dontrun{
data(fl25)
fl_map = redist_map(fl25, ndists=3, pop_tol=0.1)
sampled = redist_mergesplit_parallel(fl_map, nsims=100, chains=100)
}

}
\references{
Carter, D., Herschlag, G., Hunter, Z., and Mattingly, J. (2019). A
merge-split proposal for reversible Monte Carlo Markov chain sampling of
redistricting plans. arXiv preprint arXiv:1911.01503.

DeFord, D., Duchin, M., and Solomon, J. (2019). Recombination: A family of
Markov chains for redistricting. arXiv preprint arXiv:1911.05725.
}
\concept{simulate}
