% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{redist.district.splits}
\alias{redist.district.splits}
\title{Counts the Number of Counties within a District}
\usage{
redist.district.splits(plans, counties)
}
\arguments{
\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}

\item{counties}{A vector of county names or county ids.}
}
\value{
integer matrix where each district is a
}
\description{
Counts the total number of counties that are found within a district.
This does not subtract out the number of counties that are found completely
within a district.
}
\examples{
data(iowa)
ia <- redist_map(iowa, existing_plan = cd_2010, total_pop = pop, pop_tol = 0.01)
plans <- redist_smc(ia, 50, silent = TRUE)
splits <- redist.district.splits(plans, ia$region)
}
\concept{analyze}
