% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_constr.R
\name{constraints}
\alias{constraints}
\alias{add_constr_status_quo}
\alias{add_constr_grp_pow}
\alias{add_constr_grp_hinge}
\alias{add_constr_grp_inv_hinge}
\alias{add_constr_compet}
\alias{add_constr_incumbency}
\alias{add_constr_splits}
\alias{add_constr_multisplits}
\alias{add_constr_total_splits}
\alias{add_constr_pop_dev}
\alias{add_constr_segregation}
\alias{add_constr_polsby}
\alias{add_constr_fry_hold}
\alias{add_constr_log_st}
\alias{add_constr_edges_rem}
\alias{add_constr_custom}
\title{Sampling constraints}
\usage{
add_constr_status_quo(constr, strength, current)

add_constr_grp_pow(
  constr,
  strength,
  group_pop,
  total_pop = NULL,
  tgt_group = 0.5,
  tgt_other = 0.5,
  pow = 1
)

add_constr_grp_hinge(
  constr,
  strength,
  group_pop,
  total_pop = NULL,
  tgts_group = c(0.55)
)

add_constr_grp_inv_hinge(
  constr,
  strength,
  group_pop,
  total_pop = NULL,
  tgts_group = c(0.55)
)

add_constr_compet(constr, strength, dvote, rvote, pow = 0.5)

add_constr_incumbency(constr, strength, incumbents)

add_constr_splits(constr, strength, admin)

add_constr_multisplits(constr, strength, admin)

add_constr_total_splits(constr, strength, admin)

add_constr_pop_dev(constr, strength)

add_constr_segregation(constr, strength, group_pop, total_pop = NULL)

add_constr_polsby(constr, strength, perim_df = NULL)

add_constr_fry_hold(
  constr,
  strength,
  total_pop = NULL,
  ssdmat = NULL,
  denominator = 1
)

add_constr_log_st(constr, strength, admin = NULL)

add_constr_edges_rem(constr, strength)

add_constr_custom(constr, strength, fn)
}
\arguments{
\item{constr}{A \code{\link[=redist_constr]{redist_constr()}} object}

\item{strength}{The strength of the constraint. Higher values mean a more restrictive constraint.}

\item{current}{The reference map for the status quo constraint.}

\item{group_pop}{A vector of group population}

\item{total_pop}{A vector of total population. Defaults to the population vector used for sampling.}

\item{tgt_group, tgt_other}{Target group shares for the power-type constraint.}

\item{pow}{The exponent for the power-type constraint.}

\item{tgts_group}{A vector of target group shares for the hinge-type constraint.}

\item{dvote, rvote}{A vector of Democratic or Republican vote counts}

\item{incumbents}{A vector of unit indices for incumbents. For example, if
three incumbents live in the precincts that correspond to rows 1, 2, and
100 of your [redist_map], entering incumbents = c(1, 2, 100) would avoid
having two or more incumbents be in the same district.}

\item{admin}{A vector indicating administrative unit membership}

\item{perim_df}{A dataframe output from `redist.prep.polsbypopper`}

\item{ssdmat}{Squared distance matrix for Fryer Holden constraint}

\item{denominator}{Fryer Holden minimum value to normalize by. Default is 1 (no normalization).}

\item{fn}{A function}
}
\description{
The \code{\link[=redist_smc]{redist_smc()}} and \code{\link[=redist_mergesplit]{redist_mergesplit()}} algorithms in this package allow
for additional constraints on the redistricting process to be encoded in the
target distribution for sampling. These functions are provided to specify
these constraints. All arguments are quoted and evaluated in the context of
the data frame provided to \code{\link[=redist_constr]{redist_constr()}}.
}
\details{
All constraints are fed into a Gibbs measure, with coefficients on each
constraint set by the corresponding \code{strength} parameter.
The strength can be any real number, with zero corresponding to no constraint.
Higher and higher \code{strength} values will eventually cause the algorithm's
accuracy and efficiency to suffer. Whenever you use constraints, be sure to
check all sampling diagnostics.

The \code{status_quo} constraint adds a term measuring the variation of
information distance between the plan and the reference, rescaled to [0, 1].

The \code{grp_hinge} constraint takes a list of target group percentages. It
matches each district to its nearest target percentage, and then applies a
penalty of the form \eqn{\sqrt{max(0, tgt - grouppct)}}, summing across
districts. This penalizes districts which are below their target percentage.
Use \code{\link[=plot.redist_constr]{plot.redist_constr()}} to visualize the effect of this constraint and
calibrate \code{strength} appropriately.

The \code{grp_inv_hinge} constraint takes a list of target group percentages. It
matches each district to its nearest target percentage, and then applies a
penalty of the form \eqn{\sqrt{max(0, grouppct - tgt)}}, summing across
districts. This penalizes districts which are above their target percentage.
Use \code{\link[=plot.redist_constr]{plot.redist_constr()}} to visualize the effect of this constraint and
calibrate \code{strength} appropriately.

The \code{grp_pow} constraint (for expert use) adds a term of the form
\eqn{(|tgtgroup-grouppct||tgtother-grouppct|)^{pow})}, which
encourages districts to have group shares near either \code{tgt_group}
or \code{tgt_other}.  Values of \code{strength} depend heavily on the values of these
parameters and especially the \code{pow} parameter.
Use \code{\link[=plot.redist_constr]{plot.redist_constr()}} to visualize the effect of this constraint and
calibrate \code{strength} appropriately.

The \code{compet} constraint encourages competitiveness by applying the \code{grp_pow}
constraint with target percentages set to 50\%. For convenience, it is
specified with Democratic and Republican vote shares.

The \code{incumbency} constraint adds a term counting the number of districts
containing paired-up incumbents.
Values of \code{strength} should generally be small, given that the underlying values are counts.

The \code{splits} constraint adds a term counting the number of
counties which are split once or more.
Values of \code{strength} should generally be small, given that the underlying values are counts.

The \code{multisplits} constraint adds a term counting the number of
counties which are split twice or more.
Values of \code{strength} should generally be small, given that the underlying values are counts.

The \code{total_splits} constraint adds a term counting the total number of times
each county is split, summed across counties (i.e., counting the number of
excess district-county pairs). Values of \code{strength} should generally be
small, given that the underlying values are counts.

The \code{edges_rem} constraint adds a term counting the number of edges removed from the
adjacency graph. This is only usable with \code{redist_flip()}, as other algorithms
implicitly use this via the \code{compactness} parameter. Values of \code{strength} should
generally be small, given that the underlying values are counts.

The \code{log_st} constraint constraint adds a term counting the log number of spanning
trees. This is only usable with \code{redist_flip()}, as other algorithms
implicitly use this via the \code{compactness} parameter.

The \code{polsby} constraint adds a term encouraging compactness as defined by the
Polsby Popper metric. Values of \code{strength} may be of moderate size.

The \code{fry_hold} constraint adds a term encouraging compactness as defined by the
Fryer Holden metric. Values of \code{strength} should be extremely small, as the
underlying values are massive when the true minimum Fryer Holden denominator is not known.

The \code{segregation} constraint adds a term encouraging segregation among minority groups,
as measured by the dissimilarity index.

The \code{pop_dev} constraint adds a term encouraging plans to have smaller population deviations
from the target population.

The \code{custom} constraint allows the user to specify their own constraint using
a function which evaluates districts one at a time. The provided function
\code{fn} should take two arguments: a vector describing the current plan
assignment for each unit as its first argument, and an integer describing the
district which to evaluate in the second argument. \verb{which([plans == distr])}
would give the indices of the units that are assigned to a district \code{distr}
in any iteration. The function must return a single scalar for each plan -
district combination, where a value of 0 indicates no penalty is applied. If
users want to penalize an entire plan, they can have the penalty function
return a scalar that does not depend on the district. It is important that
\code{fn} not use information from precincts not included in \code{distr}, since in the
case of SMC these precincts may not be assigned any district at all (\code{plan}
will take the value of 0 for these precincts). The flexibility of this
constraint comes with an additional computational cost, since the other
constraints are written in C++ and so are more performant.
}
\examples{
data(iowa)
iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05)
constr <- redist_constr(iowa_map)
constr <- add_constr_splits(constr, strength = 1.5, admin = name)
constr <- add_constr_grp_hinge(constr, strength = 100,
    dem_08, tot_08, tgts_group = c(0.5, 0.6))
# encourage districts to have the same number of counties
constr <- add_constr_custom(constr, strength = 1000, fn = function(plan, distr) {
    # notice that we only use information on precincts in `distr`
    abs(sum(plan == distr) - 99/4)
})
print(constr)

}
\concept{simulate}
