% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_constr.R
\name{redist_constr}
\alias{redist_constr}
\title{Set up constraints for sampling}
\usage{
redist_constr(map = tibble())
}
\arguments{
\item{map}{a \code{\link[=redist_map]{redist_map()}} object; the map that will be used in sampling}
}
\value{
a \code{redist_constr} object, which is just a list with a certain nested structure.
}
\description{
\code{redist_constr} objects are used to specify constraints when sampling
redistricting plans with \code{\link[=redist_smc]{redist_smc()}} and \code{\link[=redist_mergesplit]{redist_mergesplit()}}. Each
constraint is specified as a function which scores a given plan. Higher
scores are penalized and sampled less frequently.
}
\details{
The \code{redist_constr} object keeps track of sampling constraints in a nested list.
You can view the exact structure of this list by calling \code{\link[=str]{str()}}.
Constraints may be added by using one of the following functions:
\itemize{
\item \code{\link[=add_constr_compet]{add_constr_compet()}}
\item \code{\link[=add_constr_custom]{add_constr_custom()}}
\item \code{\link[=add_constr_edges_rem]{add_constr_edges_rem()}}
\item \code{\link[=add_constr_fry_hold]{add_constr_fry_hold()}}
\item \code{\link[=add_constr_grp_hinge]{add_constr_grp_hinge()}}
\item \code{\link[=add_constr_grp_inv_hinge]{add_constr_grp_inv_hinge()}}
\item \code{\link[=add_constr_grp_pow]{add_constr_grp_pow()}}
\item \code{\link[=add_constr_incumbency]{add_constr_incumbency()}}
\item \code{\link[=add_constr_log_st]{add_constr_log_st()}}
\item \code{\link[=add_constr_multisplits]{add_constr_multisplits()}}
\item \code{\link[=add_constr_polsby]{add_constr_polsby()}}
\item \code{\link[=add_constr_pop_dev]{add_constr_pop_dev()}}
\item \code{\link[=add_constr_segregation]{add_constr_segregation()}}
\item \code{\link[=add_constr_splits]{add_constr_splits()}}
\item \code{\link[=add_constr_status_quo]{add_constr_status_quo()}}
\item \code{\link[=add_constr_total_splits]{add_constr_total_splits()}}
}

More information about each constraint can be found on the relevant constraint page.
}
\examples{
data(iowa)
map_ia <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
constr <- redist_constr(map_ia)
constr <- add_constr_splits(constr, strength = 1.5, admin = region)
print(constr)

}
\concept{simulate}
