% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parity.R
\name{min_move_parity}
\alias{min_move_parity}
\title{Calculates Sparse Population Moves to Minimize Population Deviation}
\usage{
min_move_parity(map, plan, counties = NULL, penalty = 0.2)
}
\arguments{
\item{map}{a \link{redist_map}}

\item{plan}{an integer vector containing the plan to be balanced.
Tidy-evaluated.}

\item{counties}{an optional vector of counties, whose boundaries will be
preserved. Tidy-evaluated.}

\item{penalty}{the larger this value, the more to encourage sparsity.}
}
\value{
a list with components:
\describe{
\item{\code{moves}}{A tibble describing the population moves}
\item{\code{pop_old}}{The current district populations}
\item{\code{pop_new}}{The district populations after the moves}
}
}
\description{
This function computes a minimal set of population moves (e.g., 5 people from
district 1 to district 3) to maximally balance the population between
districts. The moves are only allowed between districts that share the
territory of a county, so that any boundary adjustments are guaranteed to
preserve all unbroken county boundaries.
}
\examples{
data(iowa)
iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
min_move_parity(iowa_map, cd_2010)

}
\concept{analyze}
