% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertaintyRandomManual}
\alias{gridUncertaintyRandomManual}
\title{Manual function to compute AOO with grid uncertainty randomly}
\usage{
gridUncertaintyRandomManual(ecosystem.data, grid.size, n.sim = 10,
  min.percent.rule = T, percent = 1)
}
\arguments{
\item{ecosystem.data}{Raster object of an ecosystem or species distribution.
Please use a CRS with units measured in metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{n.sim}{Specifies the number of random grids to be created and tested.}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}
}
\value{
List containing the following:
\itemize{
 \item Data frame of summary statistics for the results
 \item Data frame showing the distance shifted in x and y directions used to
 create the AOO grid(s) and their associated AOOs
 \item List of RasterLayer(s) containing the AOO grid(s) which return the
 smallest AOO
}
}
\description{
\code{gridUncertaintyRandomManual} helps determine the minimum number of area of
occupancy (AOO) grid cells occupied by a species or ecosystem. It varies the
location of the AOO grid by shifting in randomly in both x- and y-
axes, returning summary statistics for the range of AOOs calculated, and the
RasterLayer(s) containing the grids with the minimum AOO. Requires manual
input for the number of simulations to perform.
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{iucnrle.org/}
}
\seealso{
\code{\link{createGrid}} \code{\link{getAOOSilent}}

Other gridUncertainty functions: \code{\link{gridUncertaintyBase}},
  \code{\link{gridUncertaintyRandom}},
  \code{\link{gridUncertaintySimulation}},
  \code{\link{gridUncertainty}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
