% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_impact_block_proxy}
\alias{d_impact_block_proxy}
\title{Partial derivatives for mean and variance impact equation using observed score proxy.}
\usage{
d_impact_block_proxy(
  p_mean,
  p_var,
  prox_data,
  mean_predictors,
  var_predictors,
  samp_size,
  num_items,
  num_quad,
  num_predictors
)
}
\arguments{
\item{p_mean}{Vector of mean impact parameters.}

\item{p_var}{Vector of variance impact parameters.}

\item{prox_data}{Vector of observed proxy scores.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{samp_size}{Sample size in data set.}

\item{num_items}{Number of items in data set.}

\item{num_predictors}{Number of predictors in dataset.}
}
\value{
a \code{"list"} of first and second partial derivatives for impact equation (to
use with multivariate Newton-Rapshon and observed proxy scores)
}
\description{
Partial derivatives for mean and variance impact equation using observed score proxy.
}
\keyword{internal}
