% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_function.R
\name{mmd_est}
\alias{mmd_est}
\title{MMD estimation}
\usage{
mmd_est(x, model, par1, par2, kernel, bdwth, control= list())
}
\arguments{
\item{x}{Data. Must be a vector for univariate models, a matrix of dimension n by d, where n is the sample size and d the dimension of the model.}

\item{model}{Parametric model to be fitted to the data. No default. See details for the list of available models.}

\item{par1}{First parameter of the model. In models where the first parameter is fixed, it is necessary to provide a value for \code{par1}. In models where the first parameter is estimated, \code{par1} can be used to provide an alternative to the default initialization of the optimization algorithms.}

\item{par2}{Second parameter of the model (if any). In models where the second parameter is fixed, it is necessary to provide a value for \code{par2}. In models where the first parameter is estimated,\code{par2} can be used to provide an alternative to the default initialization of the optimization algorithms.}

\item{kernel}{Kernel to be used in the MMD. Available options for \code{kernel} are "Gaussian" (Gaussian kernel), "Laplace" (Laplace, or exponential, kernel) and "Cauchy" (Cauchy kernel). By default, \code{kernel}="Gaussian"}

\item{bdwth}{Bandwidth parameter for the kernel. \code{bdwth} must be a strictly positive real number. By default, the value of \code{bdwth} is chosen using the  median heuristic \insertCite{garreau2017large}{regMMD}.}

\item{control}{A \code{list} of control parameters for the numerical optimization of the objective function. See details.}
}
\value{
\code{MMD_est} returns an object of \code{class} \code{"estMMD"}.

The functions \code{summary}  can be used to print the results.

An object of class \code{estMMD} is a list containing the following components:
\item{model}{Model estimated}
\item{par1}{In models where the first parameter is fixed, this is the value \code{par1} fixed by the user. In models where the first parameter is estimated, this is the initialization of the optimization procedure}
\item{par2}{In models where the second parameter is fixed, this is the value \code{par2} fixed by the user. In models where the second parameter is estimated, this is the initialization of the optimization procedure}
\item{kernel}{Kernel used in the MMD}
\item{bdwth}{Bandwidth used. That is, either the value specified by the user, either the bandwidth computedby the median heuristic}
\item{burnin}{Number of steps in the burnin of the GD or SGD algorithm}
\item{nstep}{Number of steps in the GD or SGD algorithm}
\item{stepsize}{Stepize parameter in GD or SGD}
\item{epsilon}{Parameter used in adagrad to avoid numerical errors in the computation of the step-size}
\item{method}{Optimization method used}
\item{error}{Error message (if any)}
\item{estimator}{Estimated parameter(s)}
\item{trajectory}{The full trajectory of the optimization algorithm (GD or SGD)}
\item{type}{Takes the value "\code{est}"}
}
\description{
Fits a statistical models to the data, using the robust procedure based on maximum mean discrepancy (MMD) minimization introduced and studied in \insertCite{briol2019statistical,MMD2;textual}{regMMD}.
}
\details{
Available options for \code{model} are:
\describe{
\item{"\code{beta}"}{Beta distribution with pdf \eqn{~x^{a-1}(1-x)^(b-1)} on \eqn{[0,1]}, \code{par1}\eqn{=a} and \code{par2}\eqn{=b} are both estimated.}
\item{"\code{binomial}"}{Binomial distribution with pmf \eqn{~p^{x}(1-p)^{N-x}} on \eqn{\{0,1,...,N\}}, \code{par1}\eqn{=N} and \code{par2}\eqn{=p} are both estimated. Note that in this case, if the user specifies a value for \eqn{N}, it is used as an upper bound rather than an initialization.}
\item{"\code{binomial.prob}"}{Binomial distribution with pmf \eqn{~p^{x}(1-p)^{N-x}} on \eqn{\{0,1,...,N\}}, \code{par1}\eqn{=N} is fixed and must be specified by the user while \code{par2}\eqn{=p} is estimated.}
\item{"\code{binomial.size}"}{Binomial distribution with pmf \eqn{~p^{x}(1-p)^{N-x}} on \eqn{\{0,1,...,N\}}, \code{par1}\eqn{=N} is estimated while \code{par2}\eqn{=p} fixed and must be specified by the user. Note that in this case, if the user specifies a value for \eqn{N}, it is used as an upper bound rather than an initialization.}
\item{"\code{Cauchy}"}{Cauchy distribution with pdf \eqn{~1/(1+(x-m)^2)}, \code{par1}\eqn{=m} is estimated.}
\item{"\code{continuous.uniform.loc}"}{Uniform distribution with pdf \eqn{~1} on \eqn{[m-L/2,m+L/2]}, \code{par1}\eqn{=m} is estimated while \code{par2}\eqn{=L}  is fixed and must be specified by the user.}
\item{"\code{continuous.uniform.upper}"}{Uniform distribution with pdf \eqn{~1} on \eqn{[a,b]}, \code{par1}\eqn{=a} is fixed and must be specified by the user while \code{par2}\eqn{=b} is estimated.}
\item{"\code{continuous.uniform.lower.upper}"}{Uniform distribution with pdf \eqn{~1} on \eqn{[a,b]}, \code{par1}\eqn{=a} and \code{par2}\eqn{=b} are estimated.}
\item{"\code{Dirac}"}{Dirac mass at point \eqn{a} on the reals, \code{par1}\eqn{=a} is estimated.}
\item{"\code{discrete.uniform}"}{Uniform distribution with pmf \eqn{~1} on \eqn{\{1,2,..,M\}}, \code{par1}\eqn{=M} is estimated. Note that in this case, if the user specifies a value for \eqn{M}, it is used as an upper bound rather than an initialization.}
\item{"\code{exponential}"}{Exponential distribution with pdf \eqn{~\exp(-b x)} on positive reals \eqn{R_+}, \code{par1}\eqn{=b} is estimated.}
\item{"\code{gamma}"}{Gamma distribution with pdf \eqn{~x^{a-1}\exp(-b x)} on positive reals \eqn{R_+}, \code{par1}\eqn{=a>=0.5} and \code{par2}\eqn{=b} are estimated.}
\item{"\code{gamma.shape}"}{Gamma distribution with pdf \eqn{~x^{a-1}\exp(-b x)} on positive reals \eqn{R_+}, \code{par1}\eqn{=a>=0.5} is estimated while \code{par2}\eqn{=b} is fixed and must be specified by the user.}
\item{"\code{gamma.rate}"}{Gamma distribution with pdf \eqn{~x^{a-1}\exp(-b x)} on positive reals \eqn{R_+}, \code{par1}\eqn{=a>=0.5} is fixed and must be specified by the user while \code{par2}\eqn{=b} is estimated.}
\item{"\code{Gaussian}"}{Gaussian distribution with pdf\eqn{~\exp(-(x-m)^2/2s^2)} on reals \eqn{R}, \code{par1}\eqn{=m} and \code{par2}\eqn{=s} are estimated.}
\item{"\code{Gaussian.loc}"}{Gaussian distribution with pdf \eqn{~\exp(-(x-m)^2/2s^2)} on reals \eqn{R}, \code{par1}\eqn{=m} is estimated while \code{par2}\eqn{=s} is fixed and must be specified by the user.}
\item{"\code{Gaussian.scale}"}{Gaussian distribution with pdf \eqn{~\exp(-(x-m)^2/2s^2)} on reals \eqn{R}, \code{par1}\eqn{=m} is fixed and must be specified by the user while \code{par2}\eqn{=s} is estimated.}
\item{"\code{geometric}"}{Geometric distribution with pmf \eqn{~p(1-p)^x} on \eqn{\{0,1,2,...\}}, \code{par1}\eqn{=p} is estimated.}
\item{"\code{multidim.Dirac}"}{Dirac mass at point \eqn{a} on \eqn{R^d}, \code{par1}\eqn{=a} (\eqn{d}-dimensional vector) is estimated.}
\item{"\code{multidim.Gaussian}"}{Gaussian distribution with pdf \eqn{~\exp(-(x-m)'U'U(x-m)} on \eqn{R^d}, \code{par1}\eqn{=m} (\eqn{d}-dimensional vector) and \code{par2}\eqn{=U} (\eqn{d}-\eqn{d} matrix) are estimated.}
\item{"\code{multidim.Gaussian.loc}"}{Gaussian distribution with pdf \eqn{~\exp(-\|x-m\|^2/2s^2)} on \eqn{R^d}, \code{par1}\eqn{=m} (\eqn{d}-dimensional vector) is estimated while \code{par2}\eqn{=s} is fixed.}
\item{"\code{multidim.Gaussian.scale}"}{Gaussian distribution with pdf \eqn{~\exp(-(x-m)'U'U(x-m)} on \eqn{R^d}, \code{par1}\eqn{=m} (\eqn{d}-dimensional vector) is fixed and must be specified by the user while and \code{par2}\eqn{=U} (\eqn{d}-\eqn{d} matrix) is estimated.}
\item{"\code{Pareto}"}{Pareto distribution with pmf \eqn{~1/x^{a+1}} on the reals \eqn{>1}, \code{par1}\eqn{=a} is estimated.}
\item{"\code{Poisson}"}{Poisson distribution with pmf \eqn{~b^x/x!} on \eqn{\{0,1,2,...\}}, \code{par1}\eqn{=b} is estimated.}
}

The \code{control} argument is a list  that can supply any of the following components:
\describe{
\item{burnin}{Length of the burn-in period in GD or SGD. \code{burnin} must be a non-negative integer and defaut \code{burnin}==\eqn{500}.}
\item{nsteps}{Number of iterations performed after the burn-in period in GD or SGD. \code{nsetps} must be an integer strictly larger than 2 and by default \code{nsteps}=\eqn{1000}}
\item{stepsize}{Stepsize parameter. An adaptive gradient step is used (adagrad), but it is possible to pre-multiply it by \code{stepsize}. It must be strictly positive number and by default \code{stepsize}=\eqn{1}}
\item{epsilon}{Parameter used in adagrad to avoid numerical errors in the computation of the step-size. \code{epsilon} must be a strictly positive real number and by default \code{epsilon}=\eqn{10^{-4}}.}
\item{method}{Optimization method to be used: \code{"EXACT"} for exact, \code{"GD"} for gradient descent and \code{"SGD"} for stochastic gradient descent. Not all methods are available for all models. By default, exact is preferred to GD which is prefered to SGD.}
}
}
\examples{
#simulate data
x = rnorm(50,0,1.5)

# estimate the mean and variance (assuming the data is Gaussian)
Est = mmd_est(x, model="Gaussian")

# print a summary
summary(Est)

# estimate the mean (assuming the data is Gaussian with known standard deviation =1.5)
Est2 = mmd_est(x, model="Gaussian.loc", par2=1.5)

# print a summary
summary(Est2)

# estimate the standard deviation (assuming the data is Gaussian with known mean = 0)
Est3 = mmd_est(x, model="Gaussian.scale", par1=0)

# print a summary
summary(Est3)

# test of the robustness
x[42] = 100

mean(x)

# estimate the mean and variance (assuming the data is Gaussian)
Est4 = mmd_est(x, model="Gaussian")
summary(Est4)

}
\references{
\insertAllCited{}
}
