% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_t.R
\name{plot_t}
\alias{plot_t}
\title{Plot Results for p-values and t-values}
\usage{
plot_t(
  mu_start,
  mu_end,
  n,
  y1_mean,
  y2_mean,
  y1_std,
  y2_std,
  cov,
  lower = F,
  alpha = 0.05,
  r_insteadof_cov = F
)
}
\arguments{
\item{mu_start}{Numeric. The starting value of \eqn{\mu} for the range of values to be plotted.}

\item{mu_end}{Numeric. The ending value of \eqn{\mu} for the range of values to be plotted.}

\item{n}{Numeric. The original sample size (number of observations) of the data.}

\item{y1_mean}{Numeric. The mean of the first measurement.}

\item{y2_mean}{Numeric. The mean of the second measurement.}

\item{y1_std}{Numeric. The standard deviation of the first measurement.}

\item{y2_std}{Numeric. The standard deviation of the second measurement.}

\item{cov}{Numeric. The covariance between the two measurements, or if \code{r_insteadof_cov} is \code{TRUE}, the correlation coefficient.}

\item{lower}{Logical. If \code{TRUE}, the function tests whether the second measurements are lower than expected. If \code{FALSE} (the default), it tests whether the intervention is increasing the measurements.}

\item{alpha}{Numeric. The significance threshold for the p-values of the one-sided tests. The default is \code{0.05}.}

\item{r_insteadof_cov}{Logical. If \code{TRUE}, \code{cov} is interpreted as the correlation coefficient instead of the covariance. Default is \code{FALSE}.}
}
\value{
A \code{ggplot2} plot with two y-axes: one showing p-values and the other showing t-statistics. The function also prints key values including the most significant \eqn{\mu}, the minimal p-value, and the range of \eqn{\mu} where the treatment effect is significant.
}
\description{
This function plots the t-statistics and p-values for a range of \eqn{\mu} values, based on the provided data and regression models. It helps visualize whether the intervention has a significant impact on the measurements, accounting for regression to the mean.
}
\examples{
# Example usage of the plot_t function
plot_t(
  mu_start = 0, mu_end = 10, n = 50, y1_mean = 5, 
  y2_mean = 5, y1_std = 2, y2_std = 2, cov = 0.5
)

plot_t(
  mu_start = 0, mu_end = 10, n = 50, y1_mean = 5, 
  y2_mean = 5, y1_std = 2, y2_std = 2, cov = 0.5, 
  lower = TRUE, alpha = 0.1
)

}
\references{
Ostermann, T., Willich, S. N., & Luedtke, R. (2008). Regression toward the mean - a detection method for unknown population mean based on Mee and Chua's algorithm. BMC Medical Research Methodology.
}
\author{
Julian Stein
}
