% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readResults.R
\name{readResults}
\alias{readResults}
\title{Read a simulation result set from file}
\usage{
readResults(
  N = 0,
  rel = "UN",
  gzip = TRUE,
  strPath = "",
  strVer = "",
  fileName = NULL
)
}
\arguments{
\item{N}{The number of iterations in the simulation}

\item{rel}{'UN' = unrelated, 'FS' = full-sib, 'PC' = parent-child}

\item{gzip}{If \code{TRUE} then it is assumed that the file is compressed}

\item{strPath}{Optional location of files. Must terminate with / otherwise
it will not work}

\item{strVer}{A version string, useful if more than simulation has been run}

\item{fileName}{This argument allows the user to override the default file
naming conventions of the result file}
}
\value{
a data frame with three columns labelled sib, pc, and ibs. These
represent the LRs for sibs and parent-child calculated on each simulated
profile pair, and the number of matching alleles (IBS).
}
\description{
This function will read the output from \code{sim} that has been saved to
disk
}
\details{
The arguments to this file are used to generate the input file name. The
format is very rigid, being 'results-sim-rel-N(-strVer).csv(.gz)' That is,
if strVer is something than an empty string then it is included after the
number of interations. Similarly if \code{gzip == TRUE} then the filename is
assumed to end with '.gz'
}
\examples{

data(fbiCaucs)
## not run
## write the results of 100 unrelated profile pairs to
## results-sim-UN-100.csv.gz
## and read it back in
\dontrun{
sim(100, save = T)
unrel = readResults(100)
sim(100, rel = "FS", strVer = "01", save = T)
sibs = readResults(100, rel = "FS", strVer = "01")
}

}
\seealso{
sim
}
\author{
James M. Curran
}
