% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_MI_RB.R
\name{get_MI_RB}
\alias{get_MI_RB}
\title{Create multiple imputed datasets based on assigned imputation method.}
\usage{
get_MI_RB(object, treatment, method = c("MAR", "J2R", "CR", "delta"),
  delta = 0, exclude_chains = NULL, start = NULL, end = NULL,
  seed = NULL, thin = NULL, subset = FALSE, include = TRUE,
  mess = TRUE, ...)
}
\arguments{
\item{object}{an object of class JointAI}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{method}{a method for obtaining multiple-imputed dataset. Options
include MAR, J2R, CR, and Delta adjustment.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be excluded from the output.}

\item{start}{first iteration to be used.}

\item{end}{last iteration to be used.}

\item{seed}{optional seed value.}

\item{thin}{thinning to be applied.}

\item{subset}{subset of parameters (columns of the mcmc object) to be used.}

\item{include}{should the original, incomplete data be included? Default is
\code{TRUE}.}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments pass from main function.}
}
\value{
A \code{data.frame} in which the original data (if
\code{include = TRUE}) and the imputed datasets are stacked onto
each other.\cr
The variable \code{Imputation_} indexes the imputation, while
\code{.rownr} links the rows to the rows of the original data.
In cross-sectional datasets the
variable \code{.id} is added as subject identifier.
}
\description{
Internal function, creates multiple imputed datasets based on assigned
imputation method returns multiple imputed datasets stacked
onto each other (i.e., long format; optionally including the original,
incomplete data).\cr
}
