% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_circle.R
\name{overlap_circle}
\alias{overlap_circle}
\title{Interpolate the Inclusion of the Other in the Self Scale}
\usage{
overlap_circle(response, categories = c("Self", "Other"))
}
\arguments{
\item{response}{The variable to plot.}

\item{categories}{The desired categories of the two overlapping circles.}
}
\value{
A plot of class gList, displaying overlapping circles relative
to the selected score.
}
\description{
Interpolating the Inclusion of the Other in
the Self Scale (self-other merging) easily.
}
\examples{
\dontshow{if (requireNamespace("VennDiagram", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Score of 1 (0\% overlap)
overlap_circle(1)

# Score of 3.5 (25\% overlap)
overlap_circle(3.5)

# Score of 6.84 (81.8\% overlap)
overlap_circle(6.84)

# Changing labels
overlap_circle(3.12, categories = c("Humans", "Animals"))

\donttest{
# Saving to file (PDF or PNG)
mypath <- tempfile(fileext = ".pdf")
plot <- overlap_circle(3.5)
ggplot2::ggsave(plot,
  file = mypath, width = 7,
  height = 7, unit = "in", dpi = 300
)
# Change for your own desired path
}
\dontshow{\}) # examplesIf}
}
\seealso{
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/circles}
}
\keyword{Venn}
\keyword{diagrams}
\keyword{merging}
\keyword{overlap}
\keyword{psychology}
\keyword{self-other}
\keyword{social}
