% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_assumptions.R
\name{nice_assumptions}
\alias{nice_assumptions}
\title{Easy assumptions checks}
\usage{
nice_assumptions(model)
}
\arguments{
\item{model}{The \code{\link[=lm]{lm()}} object to be passed to the function.}
}
\value{
A dataframe, with p-value results for the Shapiro-Wilk,
Breusch-Pagan, and Durbin-Watson tests, as well as a
diagnostic column reporting how many assumptions are
not respected for a given model.
Shapiro-Wilk is set to NA if n < 3 or n > 5000.
}
\description{
Test linear regression assumptions easily with a
nice summary table.
}
\details{
Interpretation: (p) values < .05 imply assumptions are
not respected. Diagnostic is how many assumptions are not
respected for a given model or variable.
}
\examples{
\dontshow{if (requireNamespace("lmtest", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a regression model (using data available in R by default)
model <- lm(mpg ~ wt * cyl + gear, data = mtcars)
nice_assumptions(model)

# Multiple dependent variables at once
model2 <- lm(qsec ~ disp + drat * carb, mtcars)
my.models <- list(model, model2)
nice_assumptions(my.models)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions useful in assumption testing:
\code{\link{nice_density}}, \code{\link{nice_normality}},
\code{\link{nice_qq}}, \code{\link{nice_varplot}},
\code{\link{nice_var}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{assumptions}
\keyword{linear}
\keyword{regression}
\keyword{statistical}
\keyword{violations}
