% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicationInterval.R
\docType{package}
\name{replicationInterval-package}
\alias{replicationInterval}
\alias{replicationInterval-package}
\title{Replication Interval Functions}
\description{
A common problem faced by journal reviewers and authors is the question of
whether the results of a replication study are consistent with the original
published study. One solution to this problem is to examine the effect size
from the original study and generate the range of effect sizes that could
reasonably be obtained (due to random sampling) in a replication attempt
(i.e., calculate a replication interval). If a replication effect size falls
outside the replication interval, then that effect likely did not occur
due to the effects of sampling error alone. Alternatively, if a replication
effect size falls within the replication interval, then the replication
effect could have reasonably occurred due to the effects of sampling error
alone. This package has functions that calculate the replication interval for 
the correlation (i.e., r), standardized mean difference (i.e., d-value), and mean. 
The calculations used in version 2.0.0 and onward differ from past calculations 
due to feedback during the journal review process. The new calculations allow 
for a more precise interpretation of the replication interval.
\tabular{ll}{
Package: \tab replicationInterval\cr
Type: \tab Package\cr
Version: \tab 2.0.1\cr
Date: \tab 2016-05-24\cr
License: \tab MIT License + file LICENSE\cr
}
}
\details{
\code{\link{ri.r}} creates a replication interval for a correlation (i.e., \emph{r} )\cr
\code{\link{ri.d}} creates a replication interval for a standardized mean difference (i.e., \emph{d} )\cr
\code{\link{ri.m}} creates a replication interval for a mean (i.e., \emph{M} )\cr

\code{\link{ri.r.demo}} demonstrates RI capture percentage for a correlation (i.e., \emph{r} )\cr
\code{\link{ri.d.demo}} demonstrates RI capture percentage for a standardized mean difference (i.e., \emph{d} )\cr
\code{\link{ri.m.demo}} demonstrates RI capture percentage for a mean (i.e., \emph{M} )\cr
}
\examples{
ri.r(r=.35,n=100,rep.n=200)
ri.d(d=.65,n1=50,n2=50,rep.n1=100,rep.n2=100)
ri.m(M=2.53,SD=1.02,n=40,rep.n=80)
}
\author{
\tabular{ll}{
Author: \tab David J. Stanley \email{dstanley@uoguelph.ca}\cr
Maintainer: \tab David J. Stanley \email{dstanley@uoguelph.ca}
}
}
\references{
Spence, J.R. & Stanley, D.J.(in prep). Replication Interval: What to expect when you're expecting a replication. \cr\cr\cr
Also: \cr\cr
Cumming, G. & Maillardet, R. (2006). Confidence intervals and replication: where will the next mean fall? \emph{Psychological Methods, 11(3)}, 217-227. \cr\cr
Estes, W.K. (1997). On the communication of information by displays of standard error and confidence intervals. \emph{Psychonomic Bulleting & Review, 4(3)}, 330-341. \cr\cr
Zou, G.Y. (2007). Toward using a confidence intervals to compare correlations. \emph{Psychological Methods, 12(4)}, 399-413. \cr
}
\keyword{package}

