% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_spread.R
\name{replyr_gather}
\alias{replyr_gather}
\title{Collect values found in gatherColumns as tuples}
\usage{
replyr_gather(df, gatherColumns, measurementNameColumn, measurementValueColumn,
  useTidyr = FALSE, eagerCompute = FALSE)
}
\arguments{
\item{df}{data item}

\item{gatherColumns}{set of columns to collect measurements from}

\item{measurementNameColumn}{new column to write measurement names to (original gatherColumns)}

\item{measurementValueColumn}{new column to write measurement values to}

\item{useTidyr}{if TRUE use tidyr instead of calculating on own (only works on local data types)}

\item{eagerCompute}{if TRUE call compute on intermediate results}
}
\value{
data item
}
\description{
Collect values found in gatherColumns as tuples naming which column the value came from (placed in measurementNameColumn)
and value found (placed in measurementValueColumn).  This is essentially a tidyr::gather, dplyr::melt, or anti-pivot.
}
\examples{

d <- data.frame(
  index = c(1, 2, 3),
  info = c('a', 'b', 'c'),
  meas1 = c('m1_1', 'm1_2', 'm1_3'),
  meas2 = c('m2_1', 'm2_2', 'm2_3'),
  stringsAsFactors = FALSE)
replyr_gather(d,c('meas1','meas2'),'meastype','meas')
replyr_gather(d,c('meas1','meas2'),'meastype','meas',useTidyr=TRUE)

}

