% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{inspectDescrAndJoinPlan}
\alias{inspectDescrAndJoinPlan}
\title{check that a join plan is consistent with table descriptions}
\usage{
inspectDescrAndJoinPlan(tDesc, columnJoinPlan, ..., checkColClasses = FALSE)
}
\arguments{
\item{tDesc}{description of tables, from \code{\link{tableDesription}} (and likely altered by user).}

\item{columnJoinPlan}{columns to join, from \code{\link{buildJoinPlan}} (and likely altered by user). Note: no column names must intersect with names of the form \code{table_CLEANEDTABNAME_present}.}

\item{...}{force later arguments to bind by name.}

\item{checkColClasses}{logical if true check for exact class name matches}
}
\value{
NULL if okay, else a string
}
\description{
check that a join plan is consistent with table descriptions
}
\examples{

# example data
d1 <- data.frame(id= 1:3,
                 weight= c(200, 140, 98),
                 height= c(60, 24, 12))
d2 <- data.frame(pid= 2:3,
                 weight= c(130, 110),
                 width= 1)
# get the initial description of table defs
tDesc <- rbind(tableDesription('d1', d1),
               tableDesription('d2', d2))
# declare keys (and give them consitent names)
tDesc$keys[[1]] <- list(PrimaryKey= 'id')
tDesc$keys[[2]] <- list(PrimaryKey= 'pid')
# build the join plan
columnJoinPlan <- buildJoinPlan(tDesc)
# confirm the plan
inspectDescrAndJoinPlan(tDesc, columnJoinPlan,
                        checkColClasses= TRUE)
# damage the plan
columnJoinPlan$sourceColumn[columnJoinPlan$sourceColumn=='width'] <- 'wd'
# find a problem
inspectDescrAndJoinPlan(tDesc, columnJoinPlan,
                        checkColClasses= TRUE)

}
