% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.htest.R
\name{report.htest}
\alias{report.htest}
\alias{report_effectsize.htest}
\alias{report_table.htest}
\alias{report_statistics.htest}
\alias{report_parameters.htest}
\alias{report_model.htest}
\alias{report_info.htest}
\alias{report_text.htest}
\title{Reporting \code{htest} objects (Correlation, t-test...)}
\usage{
\method{report}{htest}(x, ...)

\method{report_effectsize}{htest}(x, ...)

\method{report_table}{htest}(x, ...)

\method{report_statistics}{htest}(x, table = NULL, ...)

\method{report_parameters}{htest}(x, table = NULL, ...)

\method{report_model}{htest}(x, table = NULL, ...)

\method{report_info}{htest}(x, effectsize = NULL, ...)

\method{report_text}{htest}(x, table = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{htest}.}

\item{...}{Arguments passed to or from other methods.}

\item{table}{Provide the output of  \code{report_table()} to avoid its
re-computation.}

\item{effectsize}{Provide the output of \code{report_effectsize()} to avoid
its re-computation.}
}
\value{
An object of class \code{\link[=report]{report()}}.
}
\description{
Create reports for \code{htest} objects (\code{t.test()}, \code{cor.test()},
etc.).
}
\examples{
# t-tests
report(t.test(iris$Sepal.Width, iris$Sepal.Length))
report(t.test(iris$Sepal.Width, iris$Sepal.Length, var.equal = TRUE))
report(t.test(mtcars$mpg ~ mtcars$vs))
report(t.test(mtcars$mpg, mtcars$vs, paired = TRUE), verbose = FALSE)
report(t.test(iris$Sepal.Width, mu = 1))

# Correlations
report(cor.test(iris$Sepal.Width, iris$Sepal.Length))
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
\item \code{\link[=report_table]{report_table()}}
\item \code{\link[=report_parameters]{report_parameters()}}
\item \code{\link[=report_statistics]{report_statistics()}}
\item \code{\link[=report_effectsize]{report_effectsize()}}
\item \code{\link[=report_model]{report_model()}}
\item \code{\link[=report_priors]{report_priors()}}
\item \code{\link[=report_random]{report_random()}}
\item \code{\link[=report_performance]{report_performance()}}
\item \code{\link[=report_info]{report_info()}}
\item \code{\link[=report_text]{report_text()}}
}

Other types of reports:
\itemize{
\item \code{\link[=report_system]{report_system()}}
\item \code{\link[=report_packages]{report_packages()}}
\item \code{\link[=report_participants]{report_participants()}}
\item \code{\link[=report_sample]{report_sample()}}
\item \code{\link[=report_date]{report_date()}}
}

Methods:
\itemize{
\item \code{\link[=as.report]{as.report()}}
}

Template file for supporting new models:
\itemize{
\item \code{\link[=report.default]{report.default()}}
}
}
