% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_spec.R
\name{create_text}
\alias{create_text}
\title{Create text content}
\usage{
create_text(txt, width = NULL, align = "left", borders = "none")
}
\arguments{
\item{txt}{The text to create.}

\item{width}{The width of the text in the specified units of measure.  If 
no width is specified, the full page width will be used.}

\item{align}{How to align the text within the content area.  Valid values
are 'left', 'right', 'center', or 'centre'.  Default is 'left'.}

\item{borders}{Whether and where to place a border. Valid values are 'top',
'bottom', 'left', 'right', 'all', 'none', and 'outside'.  
Default is 'none'.  The 'left', 'right', and 'outside' 
border specifications only apply to RTF reports.}
}
\value{
The text specification.
}
\description{
Function to create a text specification that can be 
added as content to a report.   The text content can be used to include 
analysis on a statistical report.  A text specification is an S3 
object of class 'text_spec'.
}
\details{
To add plain text to a report, use the \code{create_text} function.  The 
function allows you to set a width and alignment for the text.  The
function will preserve any other formatting you apply to the text.  See
the \code{\link{add_content}} function to control page breaking and 
blanks spaces above or below the text.  

The text specification also accepts titles and footnotes.  See the 
\code{\link{titles}} and \code{\link{footnotes}} functions for further 
details.
}
\examples{
library(reporter)
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.txt")

# Create dummy text
dt <- paste0("Lorem ipsum dolor sit amet, consectetur adipiscing elit, ",
  "sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ",
  "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris ",
  "nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in ", 
  "reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla ",
  "pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa ",
  "qui officia deserunt mollit anim id est laborum.")

# Create the text object
txt <- create_text(dt) \%>\% 
  titles("Text Content 1.0", "Sample Text Report") \%>\% 
  footnotes("* Cicero, 1st century BCE")

# Create the report object
rpt <- create_report(tmp, orientation = "portrait") \%>\% 
  add_content(txt) 

# Write the report to the file system
write_report(rpt)

# Write the report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

#                                Text Content 1.0
#                               Sample Text Report
# 
# Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
# incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis
# nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
# Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore
# eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt
# in culpa qui officia deserunt mollit anim id est laborum.
# 
# * Cicero, 1st century BCE
#
}
\seealso{
\code{\link{titles}} to add a title block to the text,  
\code{\link{footnotes}} to add footnotes, and \code{\link{add_content}} 
to add the text object to a report.

Other text: 
\code{\link{print.text_spec}()}
}
\concept{text}
