% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-tools.R
\docType{methods}
\name{clearCache}
\alias{clearCache}
\alias{clearCache,ANY-method}
\alias{showCache}
\alias{showCache,ANY-method}
\alias{keepCache}
\alias{keepCache,ANY-method}
\title{Examining and modifying the cache}
\usage{
clearCache(x, userTags = character(), after, before, ...)

\S4method{clearCache}{ANY}(x, userTags = character(), after, before, ...)

showCache(x, userTags = character(), after, before, ...)

\S4method{showCache}{ANY}(x, userTags = character(), after, before, ...)

keepCache(x, userTags = character(), after, before, ...)

\S4method{keepCache}{ANY}(x, userTags = character(), after, before, ...)
}
\arguments{
\item{x}{A simList or a directory containing a valid archivist repository}

\item{userTags}{Character vector. If used, this will be used in place of the
                \code{after} and \code{before}.
                Specifying one or more \code{userTag} here will clear all
                objects that match those tags.
                Matching is via regular expression, meaning partial matches
                will work unless strict beginning (^) and end ($) of string
                characters are used.
                Matching will be against any of the 3 columns returned by \code{showCache()},
                i.e., \code{artifact}, \code{tagValue} or \code{tagName}.
                Also, length \code{userTags} > 1, then matching is by `and`.
                For `or` matching, use \code{|} in a single character string.
                See examples.

If neither \code{after} or \code{before} are provided, nor \code{userTags},
then all objects will be removed.
If both \code{after} and \code{before} are specified, then all objects between
\code{after} and \code{before} will be deleted.
If \code{userTags} is used, this will override \code{after} or \code{before}.}

\item{after}{A time (POSIX, character understandable by data.table).
Objects cached after this time will be shown or deleted.}

\item{before}{A time (POSIX, character understandable by data.table).
Objects cached before this time will be shown or deleted.}

\item{...}{Other arguments. Currently unused.}
}
\value{
Will clear all objects (or those that match \code{userTags}, or those
between \code{after} or \code{before}) from the repository located at
\code{cachePath} of the sim object, if \code{sim} is provided, or located in
\code{cacheRepo}.
Invisibly returns a \code{data.table} of the removed items.
}
\description{
These are convenience wrappers around \code{archivist} package functions.
They allow the user a bit of control over what is being cached.
}
\details{
\describe{
  \item{\code{clearCache}}{remove items from the cache based on their
                           \code{userTag} or \code{times} values.}
  \item{\code{keepCache}}{remove all cached items \emph{except} those based on
                          certain \code{userTags} or \code{times} values.}
  \item{\code{showCache}}{display the contents of the cache.}
}
}
\note{
If the cache is larger than 10MB, and clearCache is used, there will be
a message and a pause, if interactive, to prevent accidentally deleting of a
large cache repository.
}
\examples{
library(raster)
try(detach("package:magrittr", unload = TRUE), silent = TRUE) # magrittr,
                                    #if loaded, gives an error below

tmpDir <- file.path(tempdir(), "reproducible_examples", "Cache")
try(clearCache(tmpDir), silent = TRUE) # just to make sure it is clear

# Basic use
ranNumsA <- Cache(rnorm, 10, 16, cacheRepo = tmpDir)

# All same
ranNumsB <- Cache(rnorm, 10, 16, cacheRepo = tmpDir) # recovers cached copy
ranNumsC <- rnorm(10, 16) \%>\% Cache(cacheRepo = tmpDir) # recovers cached copy
ranNumsD <- Cache(quote(rnorm(n = 10, 16)), cacheRepo = tmpDir) # recovers cached copy

# Any minor change makes it different
ranNumsE <- rnorm(10, 6) \%>\% Cache(cacheRepo = tmpDir) # different

## Example 1: basic cache use with tags
ranNumsA <- Cache(rnorm, 4, cacheRepo = tmpDir, userTags = "objectName:a")
ranNumsB <- Cache(runif, 4, cacheRepo = tmpDir, userTags = "objectName:b")
ranNumsC <- Cache(runif, 40, cacheRepo = tmpDir, userTags = "objectName:b")

showCache(tmpDir, userTags = c("objectName"))
showCache(tmpDir, userTags = c("^a$")) # regular expression ... "a" exactly

# Fine control of cache elements -- pick out only the large runif object, and remove it
cache1 <- showCache(tmpDir, userTags = c("runif")) # show only cached objects made during runif
toRemove <- cache1[tagKey=="object.size"][as.numeric(tagValue) > 700]$artifact
clearCache(tmpDir, userTags = toRemove)
cacheAfter <- showCache(tmpDir, userTags = c("runif")) # Only the small one is left

}
\seealso{
\code{\link{mergeCache}}, \code{\link[archivist]{splitTagsLocal}}. Many more examples
in \code{\link{Cache}}
}
