% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{isInteractive}
\alias{isInteractive}
\title{Alternative to \code{interactive()} for unit testing}
\usage{
isInteractive()
}
\description{
This is a suggestion from
\url{https://www.mango-solutions.com/blog/testing-without-the-internet-using-mock-functions}
as a way to test interactive code in unit tests. Basically, in the unit tests,
we use \code{testthat::with_mock}, and inside that we redefine \code{isInteractive}
just for the test. In all other times, this returns the same things as
\code{interactive()}.
}
\examples{
\dontrun{
testthat::with_mock(
`isInteractive` = function() {browser(); TRUE},
{
  tmpdir <- tempdir()
  aa <- Cache(rnorm, 1, cacheRepo = tmpdir, userTags = "something2")
  # Test clearCache -- has an internal isInteractive() call
  clearCache(tmpdir, ask = FALSE)
  })
  }
}
\keyword{internal}
