% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{dlGoogle}
\alias{dlGoogle}
\title{Download file from Google Drive}
\usage{
dlGoogle(
  url,
  archive = NULL,
  targetFile = NULL,
  checkSums,
  skipDownloadMsg,
  destinationPath,
  overwrite,
  needChecksums
)
}
\arguments{
\item{url}{The url (link) to the file.}

\item{archive}{Optional character string giving the path of an archive
containing \code{targetFile}, or a vector giving a set of nested archives
(e.g., \code{c("xxx.tar", "inner.zip", "inner.rar")}). If there is/are (an) inner
archive(s), but they are unknown, the function will try all until it finds
the \code{targetFile}. See table in \code{\link{preProcess}}.}

\item{targetFile}{Character string giving the path to the eventual file
(raster, shapefile, csv, etc.) after downloading and extracting from a zip
or tar archive. This is the file \emph{before} it is passed to
\code{postProcess}. Currently, the internal checksumming does not checksum
the file after it is \code{postProcess}ed (e.g., cropped/reprojected/masked).
Using \code{Cache} around \code{prepInputs} will do a sufficient job in these cases.
See table in \code{\link{preProcess}}.}

\item{destinationPath}{Character string of a directory in which to download
and save the file that comes from \code{url} and is also where the function
will look for \code{archive} or \code{targetFile}. NOTE (still experimental):
To prevent repeated downloads in different locations, the user can also set
\code{options("reproducible.inputPaths")} to one or more local file paths to
search for the file before attempting to download. Default for that option is
\code{NULL} meaning do not search locally.}

\item{overwrite}{Logical. Should downloading and all the other actions occur
even if they pass the checksums or the files are all there.}
}
\description{
Download file from Google Drive
}
\author{
Eliot McIntire and Alex Chubaty
}
\keyword{internal}
