% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrintTree.R
\name{PrintTree}
\alias{PrintTree}
\title{RerF Tree Printer}
\usage{
PrintTree(forest, numTree = 1, pretty = FALSE)
}
\arguments{
\item{forest}{a rerf forest structure.}

\item{numTree}{the tree number to print. (numTree=1)}

\item{pretty}{boolean if TRUE the column of cut features are formatted nicely
for viewing. (FALSE)}
}
\value{
a data.frame with the following information about the tree:
\itemize{
 \item \code{nodeNum} The node number
 \item \code{LC} The id of the left child of the node
 \item \code{RC} The id of the right child of the node
 \item \code{CutValue} The cut value of non-terminal nodes, otherwise NA.
 \item \code{nodeClass} The class vote of a terminal node when used for classification/prediction.
 \item \code{CutFeatures} a list of ordered pairs \eqn{(d, w)}, where
 \code{d} is the original feature and \code{w} is the corresponding
 weight.
}
}
\description{
Prints the layout of a specified tree.
}
\examples{
### Train RerF on numeric data ###
library(rerf)
numTree <- 1
forest <- RerF(as.matrix(iris[, 1:4]), iris[, 5], num.core = 1L)
forest.rmc <- RerF(as.matrix(iris[, 1:4]), iris[, 5], num.core = 1L, RandMatContinuous)
(out <- PrintTree(forest, numTree))
(out.rmc <- PrintTree(forest.rmc, numTree))

}
