\name{corDiss}
\alias{corDiss}
\title{Correlation and moving correlation dissimilarity measurements (corDiss)}
\usage{
corDiss(Xr, X2 = NULL, ws = NULL, center = TRUE, scaled = TRUE)
}
\arguments{
  \item{Xr}{a \code{matrix} (or \code{data.frame})
  containing the (reference) data.}

  \item{X2}{an optional \code{matrix} (or
  \code{data.frame}) containing data of a second set of
  observations(samples).}

  \item{ws}{for moving correlation dissimilarity, an odd
  integer value which specifies the window size. If
  \code{ws = NULL}, then the window size will be equal to
  the number of variables (columns), i.e. instead moving
  correlation, the normal correlation will be used. See
  details.}

  \item{center}{a logical indicating if the spectral data
  \code{Xr} (and \code{X2} if specified) must be centered.
  If X2 is specified the data is scaled on the basis of
  \eqn{Xr \cup X2}.}

  \item{scaled}{a logical indicating if \code{Xr} (and
  \code{X2} if specified) must be scaled. If X2 is
  specified the data is scaled on the basis of \eqn{Xr \cup
  X2}.}
}
\value{
a \code{matrix} of the computed dissimilarities.
}
\description{
Computes correlation and moving correlation dissimilarity
matrices.
}
\details{
The correlation dissimilarity \eqn{cd} between two
obsvervations \eqn{x_i} and \eqn{x_j} is computed as
follows: \deqn{ cd(x_i, x_j) = \frac{1}{2}(1 - cor(x_i,
x_j)) } The avobe formlula is used when \code{ws = NULL}.
On the other hand (when \code{ws != NULL}) the moving
correlation dissimilarity \eqn{mcd} between two
obsvervations \eqn{x_i} and \eqn{x_j} is computed as
follows: \deqn{ mcd(x_i, x_j) = \frac{1}{2
ws}\sum_{k=1}^{p-ws}(1 - cor(x_{i,(k:k+ws)},
x_{j,(k:k+ws)})) } where \eqn{ws} represents a given window
size which rolls sequantially fom 1 up to \eqn{p - ws} and
\eqn{p} is the number of variables of the observations. The
function does not accept input data containing missing
values.
}
\examples{
\dontrun{
require(prospectr)
data(NIRsoil)

Xu <- NIRsoil$spc[!as.logical(NIRsoil$train),]
Xr <- NIRsoil$spc[as.logical(NIRsoil$train),]

corDiss(Xr = Xr)

corDiss(Xr = Xr, X2 = Xu)

corDiss(Xr = Xr, ws = 41)

corDiss(Xr = Xr, X2 = Xu, ws = 41)
}
}
\author{
Antine Stevens and Leonardo Ramirez-Lopez
}

