% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_farming.R
\name{run_farm_sim}
\alias{run_farm_sim}
\title{Initialise individuals and simulate farming}
\usage{
run_farm_sim(
  mine_output,
  N = 1000,
  xdim = 100,
  ydim = 100,
  repro = "sexual",
  neutral_loci = 1000,
  max_age = 9,
  min_age_move = 0,
  max_age_move = 9,
  min_age_reproduce = 0,
  max_age_reproduce = 9,
  min_age_feed = 0,
  max_age_feed = 9,
  food_consume = 0.25,
  pesticide_consume = 0.1,
  rand_age = FALSE,
  move_distance = 1,
  food_needed_surv = 0.25,
  pesticide_tolerated_surv = 0.1,
  food_needed_repr = 0,
  pesticide_tolerated_repr = 0,
  reproduction_type = "lambda",
  mating_distance = 1,
  lambda_value = 1,
  movement_bouts = 1,
  selfing = TRUE,
  feed_while_moving = FALSE,
  pesticide_while_moving = FALSE,
  mortality_type = 0,
  age_food_threshold = 0,
  age_pesticide_threshold = 0,
  farms = 4,
  time_steps = 100,
  mutation_pr = 0,
  crossover_pr = 0,
  mutation_type = 0,
  net_mu_layers = 0,
  net_mu_dir = 0,
  mutation_direction = 0,
  crop_init = "random",
  crop_rotation_type = 2,
  crop_rotation_time = 1,
  pesticide_init = "random",
  pesticide_rotation_type = 2,
  pesticide_rotation_time = 1,
  crop_per_cell = 1,
  pesticide_per_cell = 1,
  crop_sd = 0,
  pesticide_sd = 0,
  crop_min = 0,
  crop_max = 1000,
  pesticide_min = 0,
  pesticide_max = 1000,
  crop_number = 2,
  pesticide_number = 1,
  print_inds = FALSE,
  print_gens = TRUE,
  print_last = FALSE,
  K_on_birth = 1e+06,
  pesticide_start = 0,
  immigration_rate = 0,
  get_f_coef = FALSE,
  get_stats = TRUE,
  metabolism = 0,
  baseline_metabolism = 0,
  min_age_metabolism = 1,
  max_age_metabolism = 9,
  terrain = NA
)
}
\arguments{
\item{mine_output}{The output from mine_gmatrix, which will be used to
initialise the genomes and traits of pests.}

\item{N}{The number of individuals that are initialised in a simulation. 
Individuals are initialised in a random location on the landscape, and at 
least two individuals are needed.}

\item{xdim}{The number of cells in the horizontal dimension of the landscape. 
This value must be an integer greater than two.}

\item{ydim}{The number of cells in the vertical dimension of the landscape. 
This value must be an integer greater than two.}

\item{repro}{The type of reproduction that individuals undergo in the 
simulation. There are three options: (1) "asexual," in which individuals 
reproduce clonally and offspring have haploid genomes and traits identical to
their mother with the potential for mutation; (2) "sexual," in which 
individuals are monoecious (both female and male) and offspring have diploid 
genomes with alleles inherited from both parents with mutation and 
recombination; (3) "biparental," in which individuals are dioecious (only 
female or male) and offspring have diploid genomes with alleles inherited 
from both parents with mutation and recombination.}

\item{neutral_loci}{The number of loci that are completely neutral (i.e., have
no effect on fitness). These loci can be used to monitor genetic drift or
calculate inbreeding coefficients.}

\item{max_age}{This is the maximum number of time steps that an individual can
survive. Individuals that are older than this age in a time step will always 
die.}

\item{min_age_move}{This is the minimum age at which an individual can move. 
Individuals below this age will always remain on their current cell.}

\item{max_age_move}{This is the maximum age at which an individual can move. 
Individuals above this age will always remain on their current cell.}

\item{min_age_reproduce}{This is the minimum age at which an individual can be
reproductively active. No individuals below this age will engage in any 
reproductive activity, nor will they be recognised as potential mates by 
other individuals.}

\item{max_age_reproduce}{This is the maximum age at which an individual can be
reproductively active. No individuals above this age will engage in any
reproductive activity, nor will they be recognised as potential mates by
other individuals.}

\item{min_age_feed}{This is the minimum age at which an individual can eat. No
individuals below this age will be able to consume food on the landscape.}

\item{max_age_feed}{This is the maximum age at which an individual can eat. No
individuals above this age will be able to consume food on the landscape.}

\item{food_consume}{This defines how much food an individual will consume from
the cell on which it is feeding. Food consumption can take on any positive
real value, and an individual will consume up to this amount if possible (if 
not, they will consume however much food is left within their landscape 
cell).}

\item{pesticide_consume}{This defines how much pesticide an individual will
consume from the cell on which it resides. Pesticide consumption can take on 
any positive real value, and an individual will consume up to this amount if
possible (if not, they will consume however much pesticide has been placed on
the landscape cell).}

\item{rand_age}{This argument determines whether individuals in the simulation
will be initialised with a random age selected uniformly from zero to 
max_age. If FALSE, then all individuals will be initialised at age zero.}

\item{move_distance}{This is the maximum number of cells that an individual 
can move, in any direction, on the landscape during one bout of movement.}

\item{food_needed_surv}{This is the amount of food that an individual needs to
consume to survive. If the individual has not consumed this amount of food 
before the age of age_food_threshold, then they will die in the time step.}

\item{pesticide_tolerated_surv}{This is the amount of pesticide that an 
individual can tolerate and still survive. If the individual has consumed 
more than this amount of pesticide on or after the age of 
age_pesticide_threshold, then they will die in the time step.}

\item{food_needed_repr}{This is the amount of food that an individual needs to
produce one offspring. The total number of offspring that an individual 
produces in a time step is the floor value of their food consumption divided 
by this value.}

\item{pesticide_tolerated_repr}{This is the amount of pesticide tolerated 
below which an individual can reproduce. Note that individuals above the 
threshold can still mate and sire offspring,}

\item{reproduction_type}{This determines how individuals reproduce; the two 
options are "lambda" and "food_based." If "lambda," then the number of 
offspring an individual produces is sampled from a Poisson distribution with 
a fixed rate parameter lambda_value (potentially adjusted by other factors in
the simulation). If "food_based," then the number of offspring produced is 
based on the amount of food consumed by the individual.}

\item{mating_distance}{This is the distance in cells (any direction) away from
a focal individual from which they can successfully find and identify a mate 
(e.g., if 0, then only individuals on the same cell are potential mates).}

\item{lambda_value}{This is the rate parameter for the Poisson sampling of 
offspring number; it only applies when reproduction_type is set to "lambda."}

\item{movement_bouts}{This is the number of times an individual can move in a 
single time step (i.e., the number of cells that it can potentially visit). 
Each time an individual visits a new cell, it can potentially feed or consume 
pesticide.}

\item{selfing}{This determines whether or not self-fertilisation is allowed 
when repro is set to "sexual."}

\item{feed_while_moving}{If TRUE, then individuals will feed in each movement 
bout when they arrive to a new landscape cell.}

\item{pesticide_while_moving}{If TRUE, then individuals will consume pesticide
in each movement bout when they arrive to a new landscape cell.}

\item{mortality_type}{This determines how mortality is enacted in the 
simulation. Currently there is only one mortality type possible; mortality 
occurs if individuals exceed their maximum age, do not consume enough food, 
or consume too much pesticide.}

\item{age_food_threshold}{This is the age at which mortality associated with 
feeding is enacted, so an individual younger than this age will not die if 
they have not yet consumed sufficient food to satisfy food_needed_surv.}

\item{age_pesticide_threshold}{This is the age at which mortality associated 
with pesticide consumption is enacted, so an individual younger than this age
will not die even if they have exceeded their pesticide threshold.}

\item{farms}{This is the number of farms to be placed on the landscape. Farms 
are placed in blocks of roughly equal sizes using a shortest splitline 
algorithm. Farms operate independently in terms of what crops they grow and 
pesticides they apply.}

\item{time_steps}{This is the number of time steps that a simulation will run.
Simulations will be terminated before this number if extinction occurs.}

\item{mutation_pr}{This is the probability of mutation occurring at any locus 
of a newly produced offspring.}

\item{crossover_pr}{This is the probability of crossover between two 
homologous loci. This only applies for diploid genomes.}

\item{mutation_type}{This determines how mutation is modelled. If 0, then a 
completely new allele value is drawn from a normal distribution with a mean 
of mutation_direction and a standard deviation of 1 (or 1 / sqrt(2) for 
diploids, so that the expected standard devation of the sum of both allele 
values is 1). If 1, then a new value is drawn from a normal distribution with
mean mutation_direction and standard deviation of 1, and this new value is 
then added to the existing allele value.}

\item{net_mu_layers}{This is the proportion of the genome that can evolve. If 
0, then only loci values (green circles in Figure 1) can mutate. If 1, then 
loci and the first column of arrows (green circles to first column of blue 
squares in Figure 1) can mutate. If 2, then the first two columns of arrows 
in Figure 1 can mutate, and so forth. Fewer mutation layers will constrain 
the covariance among traits, while more mutation layers will allow the 
covariance structure to evolve more readily.}

\item{net_mu_dir}{The direction along the network in which net_mu_layers 
applies (not loci, green circles in Figure 1, can always mutate). If 1, then 
net_mu_layers applies in the direction from loci to traits. If 0, then the 
direction applies from traits to loci (i.e., net_mu_dir = 0 and 
net_mu_layers = 1 would mean that only the arrow values between the last 
hidden layer and traits in Figure 1 could mutate).}

\item{mutation_direction}{This allows mutations to be biased in one direction.
A default value of 0 makes positive or negative allele values equally likely.}

\item{crop_init}{Initial crop type for each farm. This can be set in one of 
two ways. First, the default value "random" will randomly assign each farm to
an initial crop to produce. Second, a vector can be used to specify the crop
initialised on each farm. The vector must be the same length as the number of
farms, and the value of each element 'i' of the vector defines which crop is
initialised for each farm i. Hence, a crop_init vector must have as many
elements as there are farms, and vector elements must include natural numbers
from 1 to the total number of crops.}

\item{crop_rotation_type}{This determines how crop types are rotated across 
the landscape. This can be set in one of two ways. First, a natural number
can specify a rotation type: (1) crops will never rotate, (2) a new crop type
will be randomly chosen every crop_rotation_time time steps for each farm, 
or (3) farms will cycle through crop types in order, with a change from one
crop type to another every crop_rotation_time time step. Second, a square 
matrix can specify the probability of transition from a focal crop type 
(rows) to the next crop type (columns). Matrix rows must therefore sum to 1. 
For example, an identity matrix (1s in the diagonal and 0s in the 
off-diagonal) would specify crops that never rotate (i.e., crop i always 
rotates to itself).}

\item{crop_rotation_time}{This determines how many time steps a crop is left 
before being refreshed and potentially changed. Note that even if the crop 
type does not change, this value still has the effect of determining how 
often crops are replenished (if some have been eaten since the last time they
were replenished).}

\item{pesticide_init}{Initial pesticide type for each farm. This can be set in
one of two ways. First, the default value "random" will randomly assign each 
farm to an initial pesticide to apply. Second, a vector can be used to 
specify the pesticide initialised on each farm. The vector must be the same 
length as the number of farms, and the value of each element 'i' of the 
vector defines which pesticide is initialised for each farm i. Hence, a 
pesticide_init vector must have as many elements as there are farms, and 
vector elements must include natural numbers from 1 to the total number of 
pesticides.}

\item{pesticide_rotation_type}{This determines how pesticide types are rotated
across the landscape. This can be set in one of two ways. First, a natural 
number can specify a rotation type: (1) pesticides will never rotate, (2) a 
new pesticide type will be randomly chosen every pesticide_rotation_time time
steps for each farm, or (3) farms will cycle through pesticide types in 
order, with a change from one pesticide type to another every 
pesticide_rotation_time time step. Second, a square matrix can specify the 
probability of transition from a focal pesticide type (rows) to the next 
pesticide type (columns). Matrix rows must therefore sum to 1. For example, 
an identity matrix (1s in the diagonal and 0s in the off-diagonal) would 
specify pesticides that never rotate (i.e., pesticide i always rotates to 
itself).}

\item{pesticide_rotation_time}{This determines how many time steps a pesticide
is left before being replenished and potentially changed. Note that unlike 
crops, pesticide levels do not decrease on the landscape over time (e.g., 
with consumption).}

\item{crop_per_cell}{This determines the expected amount of crop that is 
placed on a single landscape cell. The more crop on a cell, the more that can
be potentially consumed by individuals.}

\item{pesticide_per_cell}{This determines how much pesticide is placed on a 
single landscape cell. The higher concentration of pesticide per cell, the 
more that individuals on the cell will imbibe and potentially be affected by.}

\item{crop_sd}{This is the standard deviation of crop number placed on 
landscape cells. A default value of 0 assumes that all cells have the same 
amount of crop.}

\item{pesticide_sd}{This is the standard deviation of pesticide applied to 
each landscape cell. A default value of 0 assumes that each cell has the same
concentration of pesticide applied.}

\item{crop_min}{This is the minimum amount of crop that is possible to have on
a single cell (i.e., crop values will never be initialised to be lower than 
this value).}

\item{crop_max}{This is the maximum amount of crop that is possible to have on
a single cell (i.e., crop values will never be initialised to be higher than 
this value).}

\item{pesticide_min}{This is the minimum concentration of pesticide that is 
possible to have on a single cell (i.e., pesticide values will never be 
initialised to be lower than this value).}

\item{pesticide_max}{This is the maximum concentration of pesticide that is 
possible to have on a single cell (i.e., pesticide values will never be 
initialised to be higher than this value).}

\item{crop_number}{This is the number of unique crops that can exist on the 
landscape during the course of a simulation. The maximum number of possible 
crops is 10.}

\item{pesticide_number}{This is the number of unique pesticides that can exist
on the landscape during the course of a simulation. The maximum number of 
possible pesticides is 10.}

\item{print_inds}{If TRUE, a CSV file will print in the working directory with
every individual and all of their characteristics (i.e., locations, traits, 
genomes) in every time step. By default, this is set to FALSE and should only
be set to TRUE with extreme caution, as large populations persisting over 
long periods of time can produce extremely large CSV files.}

\item{print_gens}{If TRUE, the time step and the population size will be 
printed to the R console as the simulation is running.}

\item{print_last}{If TRUE, a CSV file will print in the working directory with
every individual and all of their characteristics (i.e., locations, traits, 
genomes) in only the last time step. Note that for large populations, the 
file size generated can be very large (10s to 100s of GBs).}

\item{K_on_birth}{This is a carrying capacity applied to new individuals 
across the entire landscape. If the total number of offspring in a time step 
exceeds this value, then offspring are removed at random until the total 
number of new offspring equals K_on_birth. In practice, this can help speed 
up simulations by avoiding the unnecessary production of individuals when 
most will perish.}

\item{pesticide_start}{This is the time step at which pesticide begins to be 
applied. No pesticide will be applied prior to this start time, so 
individuals will not experience any effects of pesticide. This can be useful 
as a tool to burn in the population prior to introducing pesticide.}

\item{immigration_rate}{This is the number of immigrant individuals arriving 
in the landscape in each time step. Immigrants are initialised in random 
locations with the same network structure (Figure 1) as individuals 
initialised at the start of the simulation, and with allele values randomly 
drawn from a standard normal distribution.}

\item{get_f_coef}{This determines whether or not inbreeding coefficients will 
be calculated for sexual populations and printed off in CSV files. Because 
this can add some computation time, it is best to set to FALSE unless it is 
needed.}

\item{get_stats}{If TRUE, a CSV file will print in the working directory with 
summary statistics for each time step. This is set to TRUE by default.}

\item{metabolism}{This determines the rate at which food consumed in previous 
time steps is lost in subsequent time steps, which can be especially relevant
if food consumed determines survival or reproductive output. Values of 0 mean
that stored gains will always persist throughout an individual’s lifetime, 
while very high values will model the gains of one time step being wiped out 
in subsequent time steps (if, e.g., the objective is to model individuals 
needing to consume food successfully in each time step to survive or 
reproduce, as opposed to having a feeding life history stage followed by a 
mating and reproduction stage).}

\item{baseline_metabolism}{This fixes a baseline metabolic rate at which food 
consumed in previous time steps is lost in subsequent steps. This fixed value
is always added to metabolism for each individual. By default, this value is 
0.}

\item{min_age_metabolism}{This determines the minimum age at which losses of 
food consumed in previous time steps enacted by metabolism and 
baseline_metabolsim can occur.}

\item{max_age_metabolism}{This determines the maximum age at which losses of 
food consumed in previous time steps enacted by metabolism and 
baseline_metabolsim can occur.}

\item{terrain}{Insert a custom terrain of different farms, which takes the
form of a matrix that includes a sequence of natural numbers in all matrix
elements. For example, if there are 4 farms, then all matrix elements must
be 1, 2, 3, or 4. Beyond this requirement, there is no restriction on where 
different farms are placed; the do not even need to be contiguous on the 
landscape. Note that a custom terrain will override the arguments farms, 
xdim, and ydim. For example, if the matrix given to the terrain argument has
10 rows and 10 columns, then the simulation will automatically set xdim and
ydim equal to 10 without any warnings. Also note that these terrain values do
not necessarily need to be farms. Through the use of a custom landscape and 
pesticide rotation option, these cells could represent something like 
diversionary feeding sites or even buildings or rivers. See vignettes and 
other documentation for details.}
}
\value{
The output in the R console is a list with two elements; the first 
element is a vector of parameter values used by the model, and the second 
element is the landscape in the simulation. The most relevant output will be
produced as CSV files within the working directory. When get_stats = TRUE, 
a file named 'population_data.csv' is produced in the working directory. When
print_last = TRUE, a complete array of all individuals and their 
characteristics is printed for the last time step in the working directory in
a file named 'last_time_step.csv' (for large simulations, this file can be 
> 1GB in size). When print_inds = TRUE, a complete array of all individuals 
in all time steps is produced in the working directory in a file named
'individuals.csv' (use this option with extreme caution for all but the
smallest simulations).
}
\description{
Initialises a new set of individuals and then simulates farming over time.
This is the main function that runs individual-based simulations of crop and
pesticide use and the evolution of pesticide resistance over time. To run 
this function, output from the mine_gmatrix function is required to specify
the covariance structure of individual traits and individual genomes. The
arguments to this function are used to initialise a landscape with the 
make_landscape function and initialise individuals with the initialise_inds
function. After initialisation, the simulation continues for up to a set 
number of time steps (unless extinction occurs), and individuals on the
landscape feed, encounter pesticide, move, reproduce, and die depending upon
the arguments specified in this function. After a specified number of time
steps, the crop or pesticide applied to a landscape cell can also change. The
end result is an evolving population of individuals that express traits 
that can potentially affect fitness (e.g., food consumption, pesticide
consumption, movement). Population level statistics are calculated by 
default and printed to a CSV, but individual level data (which includes all 
individual characteristics in a large table) need to be turned on because 
files can become extremely large (use print_inds with extreme caution and
print_last with care).
}
\examples{
gmt       <- matrix(data = 0, nrow = 4, ncol = 4);
diag(gmt) <- 1;
mg        <- mine_gmatrix(gmatrix = gmt, loci = 4, layers = 3, indivs = 100, 
                         npsize = 100, max_gen = 2, prnt_out = FALSE);
sim       <- run_farm_sim(mine_output = mg, N = 100, xdim = 40, ydim = 40, 
                         repro = "asexual", time_steps = 1, 
                         print_inds = FALSE, print_gens = FALSE,
                         print_last = FALSE, get_stats = FALSE);
}
