% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_meta_data.R
\name{gen_metadata}
\alias{gen_metadata}
\title{Search for Meta-Information for All Types of Objects}
\usage{
gen_metadata(
  code = NULL,
  category = c("Cube", "Statistic", "Table", "Variable", "Value"),
  error.ignore = FALSE,
  ...
)
}
\arguments{
\item{code}{string with a maximum length of 15 characters. Code from a GENESIS-Object. Only one code per iteration.}

\item{category}{a string. Specific object-types: 'Cube', 'Statistic', "Table", "Variable" and 'Value'. The function needs a specified object type.}

\item{error.ignore}{a logical. Indicator if the function should stop if an error occurs or no object for the request is found or if it should produce a token as response.}

\item{...}{Additional parameter of the GENESIS API call. These parameters are only affecting the GENESIS API call itself, no further processing.}
}
\value{
A list with all recalled elements from GENESIS. Attributes are added to the dataframe describing the search configuration for the returned output.
}
\description{
Function to search for meta-information for all types of objects.
}
\examples{
\dontrun{
# Find meta-information of the table with the code "11111"
object <- gen_metadata(code = "11111", category = "Table")
}

}
