% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_components_constraint.R
\name{add_components_constraint}
\alias{add_components_constraint}
\title{Add constraint to limit the number of connected components}
\usage{
add_components_constraint(problem, min_nb_components, max_nb_components)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{min_nb_components}{\code{integer} Minimum number of connected components.}

\item{max_nb_components}{\code{integer} Maximum number of connected components.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add constraint to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to specify the number of connected components that can be
present within a solution.
}
\details{
A connected component is a spatially continuous set of planning
units. This constraints applies on the set of planning units that are
selected for restoration, and allows to specify a minimum and maximum
number of connected components. In practice, this constraint is useful
to ensure the feasibility of a restoration project, and to integrate
economies of scale. Continuous restoration areas (i.e. less connected
components) are usually associated with lower costs, because it ensures that
restoration sites are not too far away from each other (e.g. lower travel
costs between sites, less areas to monitor, etc.). On the other hand,
it can be useful to enforce several disconnected restoration areas to
ensure that hazards (e.g. fire) do not strike all planning units at the
same time.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  add_restorable_constraint(
    min_restore = 10,
    max_restore = 100,
  ) \%>\%
  add_components_constraint(1, 1)

# plot preprocessed data
plot(rast(list(p$data$existing_habitat, p$data$restorable_habitat)), nc = 2)

# print problem
print(p)

# Solve problem
s <- solve(p)
# plot solution
plot(s)
}

}
\seealso{
Other constraints: 
\code{\link{add_available_areas_constraint}()},
\code{\link{add_compactness_constraint}()},
\code{\link{add_connected_constraint}()},
\code{\link{add_locked_out_constraint}()},
\code{\link{add_min_iic_constraint}()},
\code{\link{add_min_mesh_constraint}()},
\code{\link{add_restorable_constraint}()}
}
\concept{constraints}
