/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.neighborhood;

import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.restopt.grid.Grid;

public interface INeighborhood<T extends Grid> {
    public int[] getNeighbors(T var1, int var2);

    default public UndirectedGraph getFullGraph(T grid, Model model, SetType setType) {
        int nbCells = ((Grid)grid).getNbCells();
        UndirectedGraph g = new UndirectedGraph(model, nbCells, setType, false);
        for (int i = 0; i < nbCells; ++i) {
            int[] neighbors;
            g.addNode(i);
            for (int ii : neighbors = this.getNeighbors(grid, i)) {
                g.addEdge(i, ii);
            }
        }
        return g;
    }

    default public UndirectedGraph getPartialGraph(T grid, Model model, int[] cells, SetType nodeSetType, SetType edgeSetType) {
        int nbCells = ((Grid)grid).getNbCells();
        UndirectedGraph partialGraph = GraphFactory.makeStoredUndirectedGraph(model, nbCells, nodeSetType, edgeSetType);
        for (int i : cells) {
            partialGraph.addNode(i);
        }
        for (int i : cells) {
            int[] neighbors;
            for (int ii : neighbors = this.getNeighbors(grid, i)) {
                if (!partialGraph.getNodes().contains(ii)) continue;
                partialGraph.addEdge(i, ii);
            }
        }
        return partialGraph;
    }

    default public UndirectedGraph getPartialGraph(T grid, Model model, int[] cells, SetType setType) {
        return this.getPartialGraph(grid, model, cells, setType, setType);
    }

    default public UndirectedGraph getPartialGraph(T grid, int[] cells, SetType nodeSetType, SetType edgeSetType) {
        int nbCells = ((Grid)grid).getNbCells();
        UndirectedGraph partialGraph = GraphFactory.makeUndirectedGraph(nbCells, nodeSetType, edgeSetType);
        for (int i : cells) {
            partialGraph.addNode(i);
        }
        for (int i : cells) {
            int[] neighbors;
            for (int ii : neighbors = this.getNeighbors(grid, i)) {
                if (!partialGraph.getNodes().contains(ii)) continue;
                partialGraph.addEdge(i, ii);
            }
        }
        return partialGraph;
    }

    default public UndirectedGraph getPartialGraph(T grid, int[] cells, SetType setType) {
        return this.getPartialGraph(grid, cells, setType, setType);
    }

    default public UndirectedGraph getPartialGraphUB(T grid, Model model, int[] cells, SetType setType) {
        return this.getPartialGraphUB(grid, model, cells, setType, false);
    }

    default public UndirectedGraph getPartialGraphUB(T grid, Model model, int[] cells, SetType setType, boolean decr) {
        int nbCells = ((Grid)grid).getNbCells();
        UndirectedGraph partialGraph = new UndirectedGraph(model, nbCells, setType, false);
        for (int i : cells) {
            partialGraph.addNode(i);
        }
        for (int i : cells) {
            int[] neighbors;
            for (int ii : neighbors = this.getNeighbors(grid, i)) {
                if (!partialGraph.getNodes().contains(ii)) continue;
                partialGraph.addEdge(i, ii);
            }
        }
        return partialGraph;
    }
}

