/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.UpdatablePropagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class PropMember
extends Propagator<IntVar>
implements UpdatablePropagator<IntIterableRangeSet> {
    private final IntIterableRangeSet range;

    public PropMember(IntVar var, IntIterableRangeSet range) {
        super((Variable[])new IntVar[]{var}, (Priority)PropagatorPriority.UNARY, false);
        this.range = range.duplicate();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropMember.enforce(((IntVar[])this.vars)[0], this.range, this)) {
            this.setPassive();
        }
    }

    private static boolean enforce(IntVar var, IntIterableRangeSet fset, Propagator<IntVar> prop) throws ContradictionException {
        return var.removeAllValuesBut(fset, prop) && (var.hasEnumeratedDomain() || IntIterableSetUtils.includedIn(var, fset));
    }

    @Override
    public ESat isEntailed() {
        if (IntIterableSetUtils.includedIn(((IntVar[])this.vars)[0], this.range)) {
            return ESat.TRUE;
        }
        if (this.range.intersect(((IntVar[])this.vars)[0])) {
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        ((IntVar[])this.vars)[0].intersectLit(explanation.empty().copyFrom(this.range), explanation);
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " \u2208 " + this.range;
    }

    @Override
    public void update(IntIterableRangeSet values, boolean thenForcePropagate) {
        this.range.clear();
        this.range.addAll(values);
        if (thenForcePropagate) {
            this.forcePropagationOnBacktrack();
        }
    }

    @Override
    public IntIterableRangeSet getUpdatedValue() {
        return this.range.duplicate();
    }
}

