/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.ArrayUtils;

public class StrategiesSequencer<U extends Variable>
extends AbstractStrategy<U> {
    private final AbstractStrategy<U>[] strategies;
    private final IStateInt index;

    @SafeVarargs
    private static <V extends Variable> V[] make(AbstractStrategy<V> ... strategies) {
        Variable[] vars = (Variable[])strategies[0].vars.clone();
        for (int i = 1; i < strategies.length; ++i) {
            vars = ArrayUtils.append(vars, strategies[i].vars);
        }
        return vars;
    }

    @SafeVarargs
    public StrategiesSequencer(IEnvironment environment, AbstractStrategy<U> ... strategies) {
        super(StrategiesSequencer.make((AbstractStrategy[])strategies));
        this.index = environment.makeInt(0);
        this.strategies = strategies;
    }

    @SafeVarargs
    public StrategiesSequencer(AbstractStrategy<U> ... strategies) {
        super(StrategiesSequencer.make((AbstractStrategy[])strategies));
        this.index = null;
        this.strategies = strategies;
    }

    @Override
    public boolean init() {
        boolean ok = true;
        for (int i = 0; i < this.strategies.length; ++i) {
            ok &= this.strategies[i].init();
        }
        return ok;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.strategies.length; ++i) {
            this.strategies[i].remove();
        }
    }

    @Override
    public Decision<U> computeDecision(U variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        Decision<U> decision = null;
        for (int idx = this.index == null ? 0 : this.index.get(); decision == null && idx < this.strategies.length; ++idx) {
            if (!StrategiesSequencer.contains(this.strategies[idx].vars, variable)) continue;
            decision = this.strategies[idx].computeDecision(variable);
        }
        return decision;
    }

    private static boolean contains(Variable[] vars, Variable variable) {
        for (Variable v : vars) {
            if (!v.equals(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Decision<U> getDecision() {
        int idx = this.index == null ? 0 : this.index.get();
        Decision<U> decision = this.strategies[idx].getDecision();
        while (decision == null && idx < this.strategies.length - 1) {
            decision = this.strategies[++idx].getDecision();
        }
        if (this.index != null) {
            this.index.set(idx);
        }
        return decision;
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder("Sequence of:\n");
        for (int i = 0; i < this.strategies.length; ++i) {
            st.append("\t").append(this.strategies[i].toString()).append("\n");
        }
        return st.toString();
    }
}

