/*
 * Decompiled with CFR 0.152.
 */
package org.restopt;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;
import org.restopt.DataLoader;
import org.restopt.constraints.EffectiveMeshSizeConstraint;
import org.restopt.constraints.IRestoptConstraintFactory;
import org.restopt.constraints.IntegralIndexOfConnectivityConstraint;
import org.restopt.constraints.RestorableAreaConstraint;
import org.restopt.exception.RestoptException;
import org.restopt.grid.neighborhood.INeighborhood;
import org.restopt.grid.neighborhood.Neighborhoods;
import org.restopt.grid.regular.square.PartialRegularGroupedGrid;
import org.restopt.grid.regular.square.RegularSquareGrid;
import org.restopt.objectives.IRestoptObjectiveFactory;

public class RestoptProblem
implements IRestoptObjectiveFactory,
IRestoptConstraintFactory {
    public DataLoader data;
    public PartialRegularGroupedGrid grid;
    private INeighborhood neighborhood;
    public int accessibleVal;
    private Model model;
    private UndirectedGraphVar habitatGraphVar;
    private UndirectedGraphVar restoreGraph;
    public UndirectedGraph habGraph;
    private SetVar restoreSet;
    public int nonHabNonAcc;
    private int[] availablePlanningUnits;
    public IntVar minRestore;
    public IntVar totalRestorable;
    private EffectiveMeshSizeConstraint effectiveMeshSizeConstraint;
    private IntegralIndexOfConnectivityConstraint integralIndexOfConnectivityConstraint;
    private RestorableAreaConstraint restorableAreaConstraint;
    private Map<String, IntVar> additionalVariables;

    public RestoptProblem() {
    }

    public RestoptProblem(DataLoader data, int accessibleVal) {
        this.data = data;
        this.accessibleVal = accessibleVal;
        this.additionalVariables = new HashMap<String, IntVar>();
        System.out.println("Height = " + data.getHeight());
        System.out.println("Width = " + data.getWidth());
        int[] outPixels = IntStream.range(0, data.getHabitatData().length).filter(i -> data.getHabitatData()[i] <= -1 || (double)data.getHabitatData()[i] == data.noDataHabitat).toArray();
        int[] nonHabitatNonAccessiblePixels = IntStream.range(0, data.getHabitatData().length).filter(i -> data.getHabitatData()[i] == 0 && data.getAccessibleData()[i] != accessibleVal).toArray();
        int[] habitatPixelsComp = IntStream.range(0, data.getHabitatData().length).filter(i -> data.getHabitatData()[i] == 1).toArray();
        this.habGraph = Neighborhoods.FOUR_CONNECTED.getPartialGraph(new RegularSquareGrid(data.getHeight(), data.getWidth()), habitatPixelsComp, SetType.RANGESET, SetType.RANGESET);
        this.nonHabNonAcc = nonHabitatNonAccessiblePixels.length;
        this.grid = new PartialRegularGroupedGrid(data.getHeight(), data.getWidth(), ArrayUtils.concat(outPixels, nonHabitatNonAccessiblePixels), this.habGraph);
        int[] nonHabitatPixels = IntStream.range(0, data.getHabitatData().length).filter(i -> data.getHabitatData()[i] == 0).toArray();
        int[] habitatPixels = IntStream.range(0, this.grid.getNbGroups()).toArray();
        this.availablePlanningUnits = IntStream.range(0, data.getAccessibleData().length).filter(i -> data.getAccessibleData()[i] == accessibleVal && data.getHabitatData()[i] == 0).map(i -> this.grid.getGroupIndexFromCompleteIndex(i)).toArray();
        System.out.println("Current landscape state loaded");
        System.out.println("    Habitat cells = " + habitatPixelsComp.length + " ");
        System.out.println("    Non habitat cells = " + nonHabitatPixels.length + " ");
        System.out.println("    Accessible non habitat cells = " + this.availablePlanningUnits.length + " ");
        System.out.println("    Out cells = " + outPixels.length);
        this.neighborhood = Neighborhoods.PARTIAL_GROUPED_FOUR_CONNECTED;
        this.model = new Model();
        UndirectedGraph hab_LB = this.neighborhood.getPartialGraph(this.grid, this.model, habitatPixels, SetType.BIPARTITESET, SetType.BIPARTITESET);
        UndirectedGraph hab_UB = this.neighborhood.getPartialGraph(this.grid, this.model, ArrayUtils.concat(habitatPixels, this.availablePlanningUnits), SetType.BIPARTITESET, SetType.BIPARTITESET);
        this.habitatGraphVar = this.model.nodeInducedGraphVar("habitatGraph", hab_LB, hab_UB);
        this.restoreGraph = this.model.nodeInducedSubgraphView(this.habitatGraphVar, SetFactory.makeConstantSet(IntStream.range(0, this.grid.getNbGroups()).toArray()), true);
        this.restoreSet = this.model.graphNodeSetView(this.restoreGraph);
    }

    public Map<String, IntVar> getAdditionalVariables() {
        return this.additionalVariables;
    }

    public Model getModel() {
        return this.model;
    }

    public SetVar getRestoreSetVar() {
        return this.restoreSet;
    }

    public PartialRegularGroupedGrid getGrid() {
        return this.grid;
    }

    public DataLoader getData() {
        return this.data;
    }

    public UndirectedGraphVar getHabitatGraphVar() {
        return this.habitatGraphVar;
    }

    public UndirectedGraph getHabitatGraph() {
        return this.habGraph;
    }

    public int getNbLockedUpNonHabitatCells() {
        return this.nonHabNonAcc;
    }

    public UndirectedGraphVar getRestoreGraphVar() {
        return this.restoreGraph;
    }

    public IntVar getMinRestore() {
        return this.minRestore;
    }

    public IntVar getTotalRestorable() {
        return this.totalRestorable;
    }

    public int[] getAvailablePlanningUnits() {
        return this.availablePlanningUnits;
    }

    public int getRestorableArea(int pu) {
        return (int)Math.round(this.data.getRestorableData()[this.grid.getUngroupedCompleteIndex(pu)]);
    }

    public String getSearchState() {
        return this.model.getSolver().getSearchState().toString();
    }

    public INeighborhood getNeighborhood() {
        return this.neighborhood;
    }

    public boolean hasRestorableAreaConstraint() {
        return this.restorableAreaConstraint != null;
    }

    public RestorableAreaConstraint getRestorableAreaConstraint() {
        return this.restorableAreaConstraint;
    }

    public void setRestorableAreaConstraint(RestorableAreaConstraint restorableAreaConstraint) throws RestoptException {
        if (this.hasRestorableAreaConstraint()) {
            throw new RestoptException("Only one restorable area constraint can be associated with a restopt problem");
        }
        this.restorableAreaConstraint = restorableAreaConstraint;
    }

    public boolean hasMeshConstraint() {
        return this.effectiveMeshSizeConstraint != null;
    }

    public EffectiveMeshSizeConstraint getMeshConstraint() {
        return this.effectiveMeshSizeConstraint;
    }

    public void setMeshConstraint(EffectiveMeshSizeConstraint effectiveMeshSizeConstraint) throws RestoptException {
        if (this.hasMeshConstraint()) {
            throw new RestoptException("Only one mesh constraint can be associated with a restopt problem");
        }
        this.effectiveMeshSizeConstraint = effectiveMeshSizeConstraint;
    }

    public boolean hasIICConstraint() {
        return this.integralIndexOfConnectivityConstraint != null;
    }

    public IntegralIndexOfConnectivityConstraint getIICConstraint() {
        return this.integralIndexOfConnectivityConstraint;
    }

    public void setIICConstraint(IntegralIndexOfConnectivityConstraint integralIndexOfConnectivityConstraint) throws RestoptException {
        if (this.hasIICConstraint()) {
            throw new RestoptException("Only one iic constraint can be associated with a restopt problem");
        }
        this.integralIndexOfConnectivityConstraint = integralIndexOfConnectivityConstraint;
    }

    public int getLandscapeArea() {
        return this.grid.getNbUngroupedCells() + this.getNbLockedUpNonHabitatCells();
    }

    @Override
    public RestoptProblem self() {
        return this;
    }
}

