/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesBitSetTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class PropBinAC3bitrm
extends PropBinCSP {
    private int offset0;
    private int offset1;
    private int minS0;
    private int minS1;
    private int initDomSize0;
    private int initDomSize1;

    public PropBinAC3bitrm(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesBitSetTable(tuples, x, y));
        if (!x.hasEnumeratedDomain() || !y.hasEnumeratedDomain()) {
            throw new SolverException("PropBinAC3bitrm (\"AC3bit+rm\")may produce incorrect filtering with bounded variables");
        }
        this.offset0 = this.v0.getLB();
        this.offset1 = this.v1.getLB();
        this.initDomSize0 = this.v0.getUB() - this.offset0 + 1;
        this.initDomSize1 = this.v1.getUB() - this.offset1 + 1;
    }

    private PropBinAC3bitrm(IntVar x, IntVar y, CouplesBitSetTable table) {
        super(x, y, table);
        this.offset0 = this.v0.getLB();
        this.offset1 = this.v1.getLB();
        this.initDomSize0 = this.v0.getUB() - this.offset0 + 1;
        this.initDomSize1 = this.v1.getUB() - this.offset1 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.fastInitNbSupports();
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            try {
                while (itv0.hasNext()) {
                    int val0 = itv0.next();
                    if (!((CouplesBitSetTable)this.relation).checkUnsupportedValue(0, val0, this.v1)) continue;
                    this.v0.removeValue(val0, this);
                }
            }
            finally {
                itv0.dispose();
            }
            itv0 = this.v1.getValueIterator(true);
            try {
                while (itv0.hasNext()) {
                    int val1 = itv0.next();
                    if (!((CouplesBitSetTable)this.relation).checkUnsupportedValue(1, val1, this.v0)) continue;
                    this.v1.removeValue(val1, this);
                }
            }
            finally {
                itv0.dispose();
            }
        }
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.onInstantiationOf(idxVarInProp);
        } else if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    private void fastInitNbSupports() {
        int[] initS1 = new int[this.initDomSize1];
        this.minS0 = Integer.MAX_VALUE;
        this.minS1 = Integer.MAX_VALUE;
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            int initS0 = 0;
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++initS0;
                int n = val1 - this.offset1;
                initS1[n] = initS1[n] + 1;
            }
            if (initS0 < this.minS0) {
                this.minS0 = initS0;
            }
            itv1.dispose();
        }
        itv0.dispose();
        for (int i = 0; i < initS1.length; ++i) {
            if (initS1[i] >= this.minS1) continue;
            this.minS1 = initS1[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseV1() throws ContradictionException {
        int v0Size = this.v0.getDomainSize();
        if (this.minS1 <= this.initDomSize0 - v0Size) {
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            try {
                while (itv1.hasNext()) {
                    int y = itv1.next();
                    if (!((CouplesBitSetTable)this.relation).checkUnsupportedValue(1, y, this.v0)) continue;
                    this.v1.removeValue(y, this);
                }
            }
            finally {
                itv1.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseV0() throws ContradictionException {
        int v1Size = this.v1.getDomainSize();
        if (this.minS0 <= this.initDomSize1 - v1Size) {
            DisposableValueIterator itv0 = this.v0.getValueIterator(true);
            try {
                while (itv0.hasNext()) {
                    int x = itv0.next();
                    if (!((CouplesBitSetTable)this.relation).checkUnsupportedValue(0, x, this.v1)) continue;
                    this.v0.removeValue(x, this);
                }
            }
            finally {
                itv0.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiationOf(int idx) throws ContradictionException {
        if (idx == 0) {
            int value = this.v0.getValue();
            DisposableValueIterator itv1 = this.v1.getValueIterator(true);
            try {
                while (itv1.hasNext()) {
                    int val = itv1.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    this.v1.removeValue(val, this);
                }
            }
            finally {
                itv1.dispose();
            }
        }
        int value = this.v1.getValue();
        DisposableValueIterator itv0 = this.v0.getValueIterator(true);
        try {
            while (itv0.hasNext()) {
                int val = itv0.next();
                if (this.relation.isConsistent(val, value)) continue;
                this.v0.removeValue(val, this);
            }
        }
        finally {
            itv0.dispose();
        }
    }
}

