% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restorepoint.R
\name{restore.point}
\alias{restore.point}
\title{Sets a restore point}
\usage{
restore.point(name, to.global = options$to.global,
  deep.copy = options$deep.copy, force = FALSE,
  display.restore.point = options$display.restore.point,
  indent.level = TRUE, trace.calls = options$trace.calls,
  max.trace.lines = 10, dots = eval(substitute(list(...), env =
  parent.frame())), options = get.restore.point.options())
}
\arguments{
\item{name}{key under which the objects are stored. For restore points at the beginning of a function, I would suggest the name of that function.}

\item{to.global}{if TRUE (default) objects are restored by simply copying them into the global environment. If FALSE a new environment will be created and the restore point browser will be invoked.}

\item{deep.copy}{if TRUE try to make deep copies of  objects that are by default copied by reference. Works so far for environments (recursivly). The function will search lists whether they contain reference objects, but for reasons of speed not yet in other containers. E.g. if an evironment is stored in a data.frame, only a shallow copy will be made. Setting deep.copy = FALSE (DEFAULT) may be useful if storing takes very long and variables that are copied by reference are not used or not modified.}

\item{force}{store even if set.storing(FALSE) has been called}

\item{display.restore.point}{shall a text be shown in the console if restore.point is called. Can be useful when informative tracebacks are not readily availbale, e.g. when debugging shiny apps.}

\item{indent.level}{when display.restore.point=TRUE shall level of nestedness be illustrated by identation}

\item{trace.calls}{when objects are restored, shall a traceback be shown}

\item{max.trace.lines}{if trace.calls=TRUE how many lines shall be shown at most in the traceback.}

\item{dots}{by default a list of the ... argument of the function in which restore.point was called}

\item{options}{option list to fill the parameter defaults from}
}
\description{
The function behaves different when called from a function or when called from the global environemnt. When called from a function, it makes a backup copy of all local objects and stores them internally under a key specified by name. When called from the global environment, it restores the previously stored objects by copying them into the global environment. See the package Vignette for an illustration of how this function can facilitate debugging.
}
