## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(eval = FALSE)

## ------------------------------------------------------------------------
#  array(1:24, c(4,3,2))
#  
#  ## , , 1
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    5    9
#  ## [2,]    2    6   10
#  ## [3,]    3    7   11
#  ## [4,]    4    8   12
#  ##
#  ## , , 2
#  ##      [,1] [,2] [,3]
#  ## [1,]   13   17   21
#  ## [2,]   14   18   22
#  ## [3,]   15   19   23
#  ## [4,]   16   20   24

## ------------------------------------------------------------------------
#  array(1:24, c(4, 3, 2))[1,, ,drop=FALSE]
#  
#  ## , , 1
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    5    9
#  ##
#  ## , , 2
#  ##      [,1] [,2] [,3]
#  ## [1,]   13   17   21

## ------------------------------------------------------------------------
#  array(1:24, c(4, 3, 2))[1,, ,drop=TRUE]
#  
#  ##      [,1] [,2]
#  ## [1,]    1   13
#  ## [2,]    5   17
#  ## [3,]    9   21

## ------------------------------------------------------------------------
#  library(reticulate)
#  np <- import("numpy", convert=FALSE)
#  (x <- np$arange(1, 9)$reshape(2L, 2L, 2L))
#  
#  ## [[[ 1.  2.]
#  ##   [ 3.  4.]]
#  ##
#  ##  [[ 5.  6.]
#  ##   [ 7.  8.]]]
#  
#  (y <- py_to_r(x))
#  
#  ## , , 1
#  ##      [,1] [,2]
#  ## [1,]    1    3
#  ## [2,]    5    7
#  ##
#  ## , , 2
#  ##      [,1] [,2]
#  ## [1,]    2    4
#  ## [2,]    6    8

## ------------------------------------------------------------------------
#  y[1,,, drop=FALSE]
#  
#  ## , , 1
#  ##      [,1] [,2]
#  ## [1,]    1    3
#  ##
#  ## , , 2
#  ##      [,1] [,2]
#  ## [1,]    2    4
#  
#  y[1,,, drop=TRUE]
#  
#  ##      [,1] [,2]
#  ## [1,]    1    2
#  ## [2,]    3    4

## ------------------------------------------------------------------------
#  np <- import("numpy", convert=FALSE)
#  (x <- np$reshape(np$arange(1, 25), c(4L, 3L, 2L)))
#  
#  ## [[[  1.   2.]
#  ##   [  3.   4.]
#  ##   [  5.   6.]]
#  ##
#  ##  [[  7.   8.]
#  ##   [  9.  10.]
#  ##   [ 11.  12.]]
#  ##
#  ##  [[ 13.  14.]
#  ##   [ 15.  16.]
#  ##   [ 17.  18.]]
#  ##
#  ##  [[ 19.  20.]
#  ##   [ 21.  22.]
#  ##   [ 23.  24.]]]
#  
#  (y <- py_to_r(x))
#  
#  ## , , 1
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    3    5
#  ## [2,]    7    9   11
#  ## [3,]   13   15   17
#  ## [4,]   19   21   23
#  ##
#  ## , , 2
#  ##      [,1] [,2] [,3]
#  ## [1,]    2    4    6
#  ## [2,]    8   10   12
#  ## [3,]   14   16   18
#  ## [4,]   20   22   24

## ------------------------------------------------------------------------
#  np$take(x, 0L, 2L)
#  
#  ## [[  1.   3.   5.]
#  ##  [  7.   9.  11.]
#  ##  [ 13.  15.  17.]
#  ##  [ 19.  21.  23.]]
#  
#  y[, , 1]
#  
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    3    5
#  ## [2,]    7    9   11
#  ## [3,]   13   15   17
#  ## [4,]   19   21   23

## ------------------------------------------------------------------------
#  (y <- array(1:24, c(4, 3, 2)))  # In R
#  
#  ## , , 1
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    5    9
#  ## [2,]    2    6   10
#  ## [3,]    3    7   11
#  ## [4,]    4    8   12
#  ##
#  ## , , 2
#  ##      [,1] [,2] [,3]
#  ## [1,]   13   17   21
#  ## [2,]   14   18   22
#  ## [3,]   15   19   23
#  ## [4,]   16   20   24
#  
#  (x <- np$array(y))              # and now in Python
#  
#  ## [[[ 1 13]
#  ##   [ 5 17]
#  ##   [ 9 21]]
#  ##
#  ##  [[ 2 14]
#  ##   [ 6 18]
#  ##   [10 22]]
#  ##
#  ##  [[ 3 15]
#  ##   [ 7 19]
#  ##   [11 23]]
#  ##
#  ##  [[ 4 16]
#  ##   [ 8 20]
#  ##   [12 24]]]

## ------------------------------------------------------------------------
#  x$flags
#  
#  ##   C_CONTIGUOUS : False
#  ##   F_CONTIGUOUS : True
#  ##   OWNDATA : True
#  ##   WRITEABLE : True
#  ##   ALIGNED : True
#  ##   UPDATEIFCOPY : False

## ------------------------------------------------------------------------
#  y[, , 1]
#  
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    5    9
#  ## [2,]    2    6   10
#  ## [3,]    3    7   11
#  ## [4,]    4    8   12
#  
#  np$take(x, 0L, 2L)
#  
#  ## [[ 1  5  9]
#  ##  [ 2  6 10]
#  ##  [ 3  7 11]
#  ##  [ 4  8 12]]

## ------------------------------------------------------------------------
#  py_to_r(np$take(x, 0L, 2L))
#  
#  ##      [,1] [,2] [,3]
#  ## [1,]    1    5    9
#  ## [2,]    2    6   10
#  ## [3,]    3    7   11
#  ## [4,]    4    8   12

## ------------------------------------------------------------------------
#  np$reshape(np$arange(1, 25), c(4L, 3L, 2L), "F")
#  
#  ## [[[  1.  13.]
#  ##   [  5.  17.]
#  ##   [  9.  21.]]
#  ##
#  ##  [[  2.  14.]
#  ##   [  6.  18.]
#  ##   [ 10.  22.]]
#  ##
#  ##  [[  3.  15.]
#  ##   [  7.  19.]
#  ##   [ 11.  23.]]
#  ##
#  ##  [[  4.  16.]
#  ##   [  8.  20.]
#  ##   [ 12.  24.]]]

## ------------------------------------------------------------------------
#  y <- aperm(array(matrix(1:24, c(3 * 4, 2), byrow=TRUE),
#             c(3, 4, 2)), c(2, 1, 3))

## ------------------------------------------------------------------------
#  np <- import("numpy", convert=FALSE)
#  o  <- import("operator", convert=FALSE)
#  
#  o$sub(np$arange(1, 25)$reshape(4L, 3L, 2L), np$array(y))
#  
#  ## [[[ 0.  0.]
#  ##   [ 0.  0.]
#  ##   [ 0.  0.]]
#  ##
#  ##  [[ 0.  0.]
#  ##   [ 0.  0.]
#  ##   [ 0.  0.]]
#  ##
#  ##  [[ 0.  0.]
#  ##   [ 0.  0.]
#  ##   [ 0.  0.]]
#  ##
#  ##  [[ 0.  0.]
#  ##   [ 0.  0.]
#  ##   [ 0.  0.]]]

## ------------------------------------------------------------------------
#  library(reticulate)
#  np <- import("numpy", convert=FALSE)
#  x  <- np$arange(1, 25)$reshape(c(4L, 3L, 2L))
#  x$sum(0)   # N. B. a 3x2 matrix!
#  
#  ## [[ 40.  44.]
#  ##  [ 48.  52.]
#  ##  [ 56.  60.]]
#  
#  # N. B. A tuple() object is required here (NumPy vectors won't work)
#  x$sum(tuple(1L, 2L))
#  
#  ## [  21.   57.   93.  129.]

## ------------------------------------------------------------------------
#  y <- py_to_r(x)
#  apply(y, dim(y)[-1], sum)
#  
#  ##      [,1] [,2] [,3]
#  ## [1,]   40   48   56
#  ## [2,]   44   52   60
#  
#  apply(y, 1, sum)
#  
#  ## [1]  21  57  93 129

## ------------------------------------------------------------------------
#  library(tensorflow)
#  np   <- import("numpy", convert=FALSE)
#  a    <- np$arange(1, 9)$reshape(c(2L, 2L, 2L))
#  b    <- np$arange(1, 5)$reshape(c(2L, 2L, 1L))
#  c    <- tf$matmul(tf$constant(a), tf$constant(b))
#  tf$Session()$run(c)
#  
#  ## , , 1
#  ##      [,1] [,2]
#  ## [1,]    5   11
#  ## [2,]   39   53

## ------------------------------------------------------------------------
#  A <- list(matrix(1:4, nrow=2, byrow=T), matrix(5:8, nrow=2, byrow=T))
#  A <- array(unlist(A), dim=c(2,2,2))

## ------------------------------------------------------------------------
#  print(a)
#  
#  ## [[[ 1.  2.]
#  ##   [ 3.  4.]]
#  ##
#  ##  [[ 5.  6.]
#  ##   [ 7.  8.]]]
#  
#  
#  print(np$array(A))
#  
#  ## [[[1 5]
#  ##   [2 6]]
#  ##
#  ##  [[3 7]
#  ##   [4 8]]]
#  
#  
#  print(A)
#  
#  ## , , 1
#  ##      [,1] [,2]
#  ## [1,]    1    2
#  ## [2,]    3    4
#  ##
#  ## , , 2
#  ##      [,1] [,2]
#  ## [1,]    5    6
#  ## [2,]    7    8

## ------------------------------------------------------------------------
#  (A <- np$array(aperm(array(1:8, c(2,2,2)), c(3,2,1))))
#  
#  ## [[[1 2]
#  ##   [3 4]]
#  ##
#  ##  [[5 6]
#  ##   [7 8]]]

## ------------------------------------------------------------------------
#  A <- np$array(aperm(array(1:8, c(2,2,2)), c(3,2,1)))
#  B <- np$array(aperm(array(1:4, c(2,2,1)), c(2,1,3)))
#  C <- tf$matmul(tf$constant(A), tf$constant(B))
#  tf$Session()$run(C)
#  
#  ## , , 1
#  ##      [,1] [,2]
#  ## [1,]    5   11
#  ## [2,]   39   53

