% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gev_mdi}
\alias{gev_mdi}
\title{Maximal data information (MDI) prior for GEV parameters
(\eqn{\mu, \sigma, \xi})}
\usage{
gev_mdi(pars, a = 0.577215664901532, min_xi = -1, max_xi = Inf, trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 3.
GEV parameters (\eqn{\mu, \sigma, \xi}).}

\item{a}{A numeric scalar.  The default value, Euler's constant, gives the
MDI prior.}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.
Must not be \code{-Inf} because this results in an improper posterior.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatibility with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
